/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.ISelectElementCallback;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.IValueListener;
import cubex2.cs3.ingame.gui.control.ItemSelectionArray;
import cubex2.cs3.ingame.gui.control.builder.ItemSelectionArrayBuilder;
import cubex2.cs3.util.Filter;
import cubex2.cs3.util.ItemStackHelper;
import net.minecraft.item.ItemStack;

public class WindowSelectItem
extends Window {
    private ItemSelectionArray itemsArray;
    private ItemStack selectedStack = null;
    private boolean wildCardStacks = true;
    private ISelectElementCallback<ItemStack> callback;
    private final IValueListener<ItemSelectionArray> listener = new IValueListener<ItemSelectionArray>(){

        @Override
        public void onValueChanged(ItemSelectionArray control) {
            WindowSelectItem.this.btnSelect.setEnabled(control.getSelectedStack() != null);
        }
    };

    public WindowSelectItem() {
        this(false, null);
    }

    public WindowSelectItem(boolean wildCardStacks) {
        this(wildCardStacks, null);
    }

    public WindowSelectItem(boolean wildCardStacks, ISelectElementCallback<ItemStack> callback) {
        super("Select Item", 66, 197, 211);
        this.wildCardStacks = wildCardStacks;
        this.callback = callback;
        this.itemsArray = (ItemSelectionArray)new ItemSelectionArrayBuilder(ItemStackHelper.getAllItemStacks(wildCardStacks), this.defaultBuilderContainer).left(7).top(7).right(7).height(177).add();
        this.itemsArray.listener = this.listener;
        this.itemsArray.filter = Filter.ITEM_STACK;
        this.claimFocus(this.itemsArray.getSearchBox());
        this.btnSelect.setEnabled(false);
    }

    public void setCallback(ISelectElementCallback<ItemStack> callback) {
        this.callback = callback;
    }

    public ItemStack getSelectedStack() {
        return this.selectedStack;
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCancel) {
            this.selectedStack = null;
            GuiBase.openPrevWindow();
        } else if (c == this.btnSelect) {
            this.selectedStack = this.itemsArray.getSelectedStack();
            if (this.callback != null) {
                this.callback.itemSelected(this.selectedStack);
            }
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }
}

