/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import com.google.common.base.Predicate;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.ISelectElementCallback;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemClickListener;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import cubex2.cs3.util.Filter;
import cubex2.cs3.util.ItemStackHelper;
import java.util.List;
import net.minecraft.item.ItemStack;

public class WindowSelectBlock
extends Window
implements IListBoxItemClickListener<ItemStack> {
    private ListBox<ItemStack> lbItems;
    private ItemStack selectedStack = null;
    private boolean wildCardStacks = true;
    private boolean subBlocks = true;
    private ISelectElementCallback<ItemStack> callback;
    private Predicate<ItemStack> itemFilter;

    public WindowSelectBlock() {
        this(false, false, null, null);
    }

    public WindowSelectBlock(boolean wildCardStacks, boolean subBlocks, ISelectElementCallback<ItemStack> callback, Predicate<ItemStack> itemFilter) {
        super("Select Block", 66, 197, 211);
        this.wildCardStacks = wildCardStacks;
        this.subBlocks = subBlocks;
        this.callback = callback;
        this.itemFilter = itemFilter;
        ListBoxDescription desc = new ListBoxDescription(7, 7);
        desc.elementWidth = 22;
        desc.elementHeight = 22;
        desc.columns = 7;
        desc.rows = 7;
        desc.elements = this.getStacks();
        desc.hasSearchBar = true;
        desc.filter = Filter.ITEM_STACK;
        this.lbItems = (ListBox)this.listBox(desc).left(7).top(7).right(7).add();
        this.btnSelect.setEnabled(false);
    }

    private List<ItemStack> getStacks() {
        List<ItemStack> stacks;
        List<ItemStack> list = stacks = this.subBlocks ? ItemStackHelper.getBlockStacks(this.wildCardStacks) : ItemStackHelper.getBlockStacks();
        if (this.itemFilter != null) {
            for (int i = 0; i < stacks.size(); ++i) {
                if (this.itemFilter.apply((Object)stacks.get(i))) continue;
                stacks.remove(i--);
            }
        }
        return stacks;
    }

    public void setCallback(ISelectElementCallback<ItemStack> callback) {
        this.callback = callback;
    }

    public ItemStack getSelectedStack() {
        return this.selectedStack;
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCancel) {
            this.selectedStack = null;
            GuiBase.openPrevWindow();
        } else if (c == this.btnSelect) {
            if (this.callback != null) {
                this.callback.itemSelected(this.selectedStack);
            }
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    public void itemClicked(ItemStack item, ListBox<ItemStack> listBox, int button) {
        this.btnSelect.setEnabled(listBox.getSelectedIndex() != -1);
        this.selectedStack = listBox.getSelectedItem();
    }
}

