/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.BaseContentPackLoader;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.IValidityProvider;
import cubex2.cs3.ingame.gui.control.Label;
import cubex2.cs3.ingame.gui.control.TextBox;

public class WindowNewPack
extends Window
implements IValidityProvider {
    private Label lblName = (Label)this.label("Name:").at(7, 7).add();
    private Label lblId;
    private TextBox tbName = (TextBox)this.textBox().below(this.lblName).fillWidth(7).height(17).add();
    private TextBox tbId;

    public WindowNewPack() {
        super("New Content Pack", 10, 180, 201);
        this.tbName.setValidityProvider(this);
        this.lblId = this.label("ID:").below(this.tbName).add();
        this.infoButton("This has to be unique and|is used to reference items,|blocks and textures.").rightTo(this.lblId).add();
        this.tbId = (TextBox)this.textBox().below(this.lblId).fillWidth(7).height(17).add();
        this.tbId.setValidityProvider(this);
        this.label("You need to restart Minecraft\nfor the pack to appear.").below(this.tbId, 10).add();
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCreate) {
            BaseContentPackLoader.instance().createContentPack(this.tbName.getText().trim(), this.tbId.getText().trim());
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    public String checkValidity(TextBox tb) {
        String message = null;
        String text = tb.getText().trim();
        if (text.length() == 0) {
            message = tb == this.tbName ? "Enter a name." : "Enter an ID.";
        } else if (text.contains(" ") && tb == this.tbId) {
            message = "Whitespaces are not allowed.";
        } else {
            for (BaseContentPack pack : BaseContentPackLoader.instance().getContentPacks()) {
                if (tb == this.tbName) {
                    if (!pack.name.equals(text)) continue;
                    message = "There is already a pack with this name.";
                    break;
                }
                if (!pack.id.equals(text)) continue;
                message = "There is already a pack with this id.";
                break;
            }
        }
        return message;
    }
}

