/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.TradeRecipe;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.WindowEditOrCreate;
import cubex2.cs3.ingame.gui.WindowSelectItem;
import cubex2.cs3.ingame.gui.control.ButtonUpDown;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.DropBox;
import cubex2.cs3.ingame.gui.control.IStringProvider;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.control.Label;
import cubex2.cs3.ingame.gui.control.PictureBox;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.lib.TextBoxValidators;
import cubex2.cs3.lib.Textures;
import cubex2.cs3.lib.Validators;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class WindowEditOrCreateTradeRecipe
extends WindowEditOrCreate<TradeRecipe>
implements IWindowClosedListener<WindowSelectItem> {
    private ItemDisplay input1;
    private ItemDisplay input2;
    private ItemDisplay result;
    private PictureBox pbArrow;
    private ButtonUpDown btnIncrInput1;
    private ButtonUpDown btnDecrInput1;
    private ButtonUpDown btnIncrInput2;
    private ButtonUpDown btnDecrInput2;
    private ButtonUpDown btnIncrResult;
    private ButtonUpDown btnDecrResult;
    private DropBox<Integer> dbProfession;
    private TextBox tbChance;
    private static IStringProvider<Integer> VILLAGER_PROFESSION = new IStringProvider<Integer>(){

        @Override
        public String getStringFor(Integer value) {
            switch (value) {
                case 0: {
                    return "Farmer";
                }
                case 1: {
                    return "Librarian";
                }
                case 2: {
                    return "Priest";
                }
                case 3: {
                    return "Blacksmith";
                }
                case 4: {
                    return "Butcher";
                }
            }
            return value.toString();
        }
    };

    public WindowEditOrCreateTradeRecipe(BaseContentPack pack) {
        super("New Trade Recipe", 180, 150, pack);
    }

    public WindowEditOrCreateTradeRecipe(TradeRecipe recipe, BaseContentPack pack) {
        super("Edit Trade Recipe", 180, 150, recipe, pack);
    }

    @Override
    protected void initControls() {
        this.input1 = (ItemDisplay)this.itemDisplay().at(37, 25).add();
        this.input1.useSelectItemDialog(false);
        this.input1.setValidatorFunc(Validators.ITEM_DISPLAY_NOT_NULL);
        this.input1.setDrawSlotBackground();
        this.btnIncrInput1 = (ButtonUpDown)this.buttonUp().left(this.input1, 1).top(24).add();
        this.btnDecrInput1 = (ButtonUpDown)this.buttonDown().left(this.input1, 1).top(this.btnIncrInput1, 0).add();
        this.input2 = (ItemDisplay)this.itemDisplay().at(67, 25).add();
        this.input2.useSelectItemDialog(false);
        this.input2.setDrawSlotBackground();
        this.btnIncrInput2 = (ButtonUpDown)this.buttonUp().left(this.input2, 1).top(24).add();
        this.btnDecrInput2 = (ButtonUpDown)this.buttonDown().left(this.input2, 1).top(this.btnIncrInput2, 0).add();
        this.pbArrow = (PictureBox)this.pictureBox(Textures.CONTROLS, 218, 18).at(97, 26).size(22, 15).add();
        this.result = (ItemDisplay)this.itemDisplay().at(126, 25).add();
        this.result.useSelectItemDialog(false);
        this.result.setValidatorFunc(Validators.ITEM_DISPLAY_NOT_NULL);
        this.result.setDrawSlotBackground();
        this.btnIncrResult = (ButtonUpDown)this.buttonUp().left(this.result, 1).top(24).add();
        this.btnDecrResult = (ButtonUpDown)this.buttonDown().left(this.result, 1).top(this.btnIncrResult, 0).add();
        Label label = (Label)this.label("Profession").below(this.input1, 7).add();
        ArrayList villagers = Lists.newArrayList();
        villagers.add(0);
        villagers.add(1);
        villagers.add(2);
        villagers.add(3);
        villagers.add(4);
        villagers.addAll(VillagerRegistry.getRegisteredVillagers());
        this.dbProfession = (DropBox)this.dropBox(villagers.toArray(new Integer[villagers.size()])).below(label).width(60).add();
        this.dbProfession.setStringProvider(VILLAGER_PROFESSION);
        this.dbProfession.setSelectedValue(0);
        label = (Label)this.label("Chance").below(this.dbProfession, 5).add();
        this.tbChance = (TextBox)this.textBox().below(label).width(60).add();
        this.tbChance.setText("0.0");
        this.tbChance.setValidityProvider(TextBoxValidators.FLOAT_ZERO_ONE);
        if (this.editingContent != null) {
            this.input1.setItemStack(((TradeRecipe)this.editingContent).input1);
            this.input2.setItemStack(((TradeRecipe)this.editingContent).input2);
            this.result.setItemStack(((TradeRecipe)this.editingContent).result);
            this.dbProfession.setSelectedValue(((TradeRecipe)this.editingContent).profession);
            this.tbChance.setText(((TradeRecipe)this.editingContent).chance + "");
        }
        this.updateButtons();
        this.updateValidation();
    }

    @Override
    protected TradeRecipe createContent() {
        return new TradeRecipe(this.dbProfession.getSelectedValue(), this.input1.getItemStack(), this.input2.getItemStack(), this.result.getItemStack(), Float.parseFloat(this.tbChance.getText()), this.pack);
    }

    @Override
    protected void editContent() {
        ((TradeRecipe)this.editingContent).profession = this.dbProfession.getSelectedValue();
        ((TradeRecipe)this.editingContent).input1 = this.input1.getItemStack();
        ((TradeRecipe)this.editingContent).input2 = this.input2.getItemStack();
        ((TradeRecipe)this.editingContent).result = this.result.getItemStack();
        ((TradeRecipe)this.editingContent).chance = Float.parseFloat(this.tbChance.getText());
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnIncrInput1) {
            this.increaseAmount(this.input1);
        } else if (c == this.btnDecrInput1) {
            this.decreaseAmount(this.input1);
        } else if (c == this.btnIncrInput2) {
            this.increaseAmount(this.input2);
        } else if (c == this.btnDecrInput2) {
            this.decreaseAmount(this.input2);
        } else if (c == this.btnIncrResult) {
            this.increaseAmount(this.result);
        } else if (c == this.btnDecrResult) {
            this.decreaseAmount(this.result);
        }
        super.controlClicked(c, mouseX, mouseY);
    }

    private void increaseAmount(ItemDisplay display) {
        int stackSize = display.getItemStack().field_77994_a;
        stackSize = Math.min(display.getItemStack().func_77976_d(), stackSize + (GuiBase.func_146272_n() ? 5 : 1));
        display.setStackSize(stackSize);
        this.updateButtons();
    }

    private void decreaseAmount(ItemDisplay display) {
        int stackSize = display.getItemStack().field_77994_a;
        stackSize = Math.max(1, stackSize - (GuiBase.func_146272_n() ? 5 : 1));
        display.setStackSize(stackSize);
        this.updateButtons();
    }

    private void updateButtons() {
        ItemStack stackInput1 = this.input1.getItemStack();
        ItemStack stackInput2 = this.input2.getItemStack();
        ItemStack stackResult = this.result.getItemStack();
        this.btnIncrInput1.setEnabled(stackInput1 != null && stackInput1.field_77994_a < stackInput1.func_77976_d());
        this.btnDecrInput1.setEnabled(stackInput1 != null && stackInput1.field_77994_a > 1);
        this.btnIncrInput2.setEnabled(stackInput2 != null && stackInput2.field_77994_a < stackInput2.func_77976_d());
        this.btnDecrInput2.setEnabled(stackInput2 != null && stackInput2.field_77994_a > 1);
        this.btnIncrResult.setEnabled(stackResult != null && stackResult.field_77994_a < stackResult.func_77976_d());
        this.btnDecrResult.setEnabled(stackResult != null && stackResult.field_77994_a > 1);
    }

    @Override
    public void windowClosed(WindowSelectItem window) {
        this.updateButtons();
    }
}

