/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import com.google.common.collect.Lists;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.SmeltingRecipe;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.WindowEditOrCreate;
import cubex2.cs3.ingame.gui.WindowSelectString;
import cubex2.cs3.ingame.gui.control.Button;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.control.PictureBox;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.lib.TextBoxValidators;
import cubex2.cs3.lib.Textures;
import cubex2.cs3.lib.Validators;
import cubex2.cs3.registry.SmeltingRecipeRegistry;
import net.minecraft.item.ItemStack;

public class WindowEditOrCreateSmeltingRecipe
extends WindowEditOrCreate<SmeltingRecipe>
implements IWindowClosedListener {
    private ItemDisplay inputDisplay;
    private ItemDisplay resultDisplay;
    private PictureBox pbArrow;
    private TextBox tbRecipes;
    private Button btnSelectList;

    public WindowEditOrCreateSmeltingRecipe(BaseContentPack pack) {
        super("New Smelting Recipe", 180, 100, pack);
    }

    public WindowEditOrCreateSmeltingRecipe(SmeltingRecipe recipe, BaseContentPack pack) {
        super("Edit Smelting Recipe", 180, 100, recipe, pack);
    }

    @Override
    protected void initControls() {
        this.inputDisplay = (ItemDisplay)this.itemDisplay().at(55, 20).add();
        this.inputDisplay.setValidatorFunc(Validators.ITEM_DISPLAY_SMELTING_INPUT);
        this.inputDisplay.setDrawSlotBackground();
        this.inputDisplay.useSelectItemDialog(false);
        this.resultDisplay = (ItemDisplay)this.itemDisplay().at(107, 20).add();
        this.resultDisplay.setValidatorFunc(Validators.ITEM_DISPLAY_NOT_NULL);
        this.resultDisplay.setDrawSlotBackground();
        this.resultDisplay.useSelectItemDialog(false);
        this.label("Recipe List:").left(7).top(this.inputDisplay, 8).add();
        if (this.editingContent != null) {
            this.inputDisplay.setItemStack(((SmeltingRecipe)this.editingContent).input);
            this.resultDisplay.setItemStack(((SmeltingRecipe)this.editingContent).result);
            this.tbRecipes = (TextBox)this.textBox().below(this.lastControl).fillWidth(7).add();
            this.tbRecipes.setText(((SmeltingRecipe)this.editingContent).recipeList);
        } else {
            this.tbRecipes = (TextBox)this.textBox().below(this.lastControl).left(7).right(70).add();
            this.tbRecipes.setText("vanilla");
            this.btnSelectList = (Button)this.button("Select").rightTo(this.tbRecipes).add();
        }
        this.tbRecipes.setValidityProvider(TextBoxValidators.NOT_EMPTY);
        this.tbRecipes.setEnabled(this.editingContent == null);
        this.pbArrow = (PictureBox)this.pictureBox(Textures.CONTROLS, 218, 18).at(77, 20).size(22, 15).add();
        this.updateValidation();
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnSelectList) {
            Object[] recipeLists = ((SmeltingRecipeRegistry)this.pack.getContentRegistry(SmeltingRecipe.class)).getRecipeLists();
            GuiBase.openWindow(new WindowSelectString("Select Recipe List", Lists.newArrayList((Object[])recipeLists)));
        } else {
            super.controlClicked(c, mouseX, mouseY);
        }
    }

    @Override
    protected SmeltingRecipe createContent() {
        ItemStack input = this.inputDisplay.getItemStack();
        ItemStack result = this.resultDisplay.getItemStack();
        return new SmeltingRecipe(this.tbRecipes.getText(), input, result, this.pack);
    }

    @Override
    protected void editContent() {
        ((SmeltingRecipe)this.editingContent).input = this.inputDisplay.getItemStack();
        ((SmeltingRecipe)this.editingContent).result = this.resultDisplay.getItemStack();
    }

    public void windowClosed(Window window) {
        WindowSelectString wdw;
        if (window instanceof WindowSelectString && (wdw = (WindowSelectString)window).getSelectedElement() != null) {
            this.tbRecipes.setText(wdw.getSelectedElement());
        }
    }
}

