/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import com.google.common.collect.Lists;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.ShapelessRecipe;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.WindowEditOrCreate;
import cubex2.cs3.ingame.gui.WindowSelectItem;
import cubex2.cs3.ingame.gui.WindowSelectRecipeInput;
import cubex2.cs3.ingame.gui.control.ButtonUpDown;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.control.PictureBox;
import cubex2.cs3.ingame.gui.control.RecipeInputDisplay;
import cubex2.cs3.lib.Textures;
import cubex2.cs3.util.RecipeInput;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class WindowEditOrCreateShapelessRecipe
extends WindowEditOrCreate<ShapelessRecipe>
implements IWindowClosedListener {
    private RecipeInputDisplay[] inputDisplays;
    private ItemDisplay resultDisplay;
    private PictureBox pbArrow;
    private ButtonUpDown btnIncrAmount;
    private ButtonUpDown btnDecrAmount;

    public WindowEditOrCreateShapelessRecipe(BaseContentPack pack) {
        super("New Shapeless Recipe", 180, 150, pack);
    }

    public WindowEditOrCreateShapelessRecipe(ShapelessRecipe recipe, BaseContentPack pack) {
        super("Edit Shapeless Recipe", 180, 150, recipe, pack);
    }

    @Override
    protected void initControls() {
        int i;
        this.inputDisplays = new RecipeInputDisplay[9];
        for (i = 0; i < 9; ++i) {
            int row = i / 3;
            int col = i % 3;
            this.inputDisplays[i] = ((RecipeInputDisplay)this.recipeInputDisplay().left(33 + col * 18).top(10 + row * 18).add()).setDrawSlotBackground();
            this.inputDisplays[i].setClearOnRightClick();
        }
        this.resultDisplay = ((ItemDisplay)this.itemDisplay().left(121).top(28).add()).setDrawSlotBackground();
        this.resultDisplay.setClearOnRightClick();
        this.btnIncrAmount = (ButtonUpDown)this.buttonUp().left(138).top(27).add();
        this.btnDecrAmount = (ButtonUpDown)this.buttonDown().left(138).top(36).add();
        if (this.editingContent != null) {
            for (i = 0; i < ((ShapelessRecipe)this.editingContent).input.length; ++i) {
                this.inputDisplays[i].setRecipeInput(((ShapelessRecipe)this.editingContent).input[i]);
            }
            this.resultDisplay.setItemStack(((ShapelessRecipe)this.editingContent).result);
        }
        this.pbArrow = (PictureBox)this.pictureBox(Textures.CONTROLS, 218, 18).left(93).top(28).size(22, 15).add();
        this.updateButtons();
    }

    @Override
    protected ShapelessRecipe createContent() {
        ItemStack result = this.resultDisplay.getItemStack();
        RecipeInput[] inputs = this.getRecipeInput();
        return new ShapelessRecipe(inputs, result, this.pack);
    }

    @Override
    protected void editContent() {
        ItemStack result = this.resultDisplay.getItemStack();
        RecipeInput[] inputs = this.getRecipeInput();
        ((ShapelessRecipe)this.editingContent).result = result;
        ((ShapelessRecipe)this.editingContent).input = inputs;
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.resultDisplay) {
            GuiBase.openWindow(new WindowSelectItem(false), "result");
        } else if (c == this.btnIncrAmount) {
            int stackSize = this.resultDisplay.getItemStack().field_77994_a;
            stackSize = Math.min(this.resultDisplay.getItemStack().func_77976_d(), stackSize + (GuiBase.func_146272_n() ? 5 : 1));
            this.resultDisplay.setStackSize(stackSize);
            this.updateButtons();
        } else if (c == this.btnDecrAmount) {
            int stackSize = this.resultDisplay.getItemStack().field_77994_a;
            stackSize = Math.max(1, stackSize - (GuiBase.func_146272_n() ? 5 : 1));
            this.resultDisplay.setStackSize(stackSize);
            this.updateButtons();
        } else {
            int index = ArrayUtils.indexOf((Object[])this.inputDisplays, (Object)c);
            if (index != -1) {
                GuiBase.openWindow(new WindowSelectRecipeInput(this.pack), "" + index);
            } else {
                super.controlClicked(c, mouseX, mouseY);
            }
        }
    }

    private RecipeInput[] getRecipeInput() {
        ArrayList inputs = Lists.newArrayList();
        for (RecipeInputDisplay display : this.inputDisplays) {
            if (display.getRecipeInput() == null) continue;
            inputs.add(display.getRecipeInput());
        }
        return inputs.toArray(new RecipeInput[inputs.size()]);
    }

    private void updateButtons() {
        boolean validData;
        boolean bl = validData = this.resultDisplay.getItemStack() != null && this.getRecipeInput().length > 0;
        if (this.editingContent == null) {
            this.btnCreate.setEnabled(validData);
        } else {
            this.btnEdit.setEnabled(validData);
        }
        ItemStack result = this.resultDisplay.getItemStack();
        this.btnIncrAmount.setEnabled(result != null && result.field_77994_a < result.func_77976_d());
        this.btnDecrAmount.setEnabled(result != null && result.field_77994_a > 1);
    }

    public void windowClosed(Window window) {
        if (window.tag.equals("result")) {
            WindowSelectItem w = (WindowSelectItem)window;
            if (w.getSelectedStack() != null) {
                this.resultDisplay.setItemStack(w.getSelectedStack());
                this.updateButtons();
            }
        } else {
            WindowSelectRecipeInput w = (WindowSelectRecipeInput)window;
            if (w.getSelectedInput() != null) {
                this.inputDisplays[Integer.parseInt(w.tag)].setRecipeInput(w.getSelectedInput());
                this.updateButtons();
            }
        }
    }
}

