/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.ShapedRecipe;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.WindowEditOrCreate;
import cubex2.cs3.ingame.gui.WindowSelectItem;
import cubex2.cs3.ingame.gui.WindowSelectRecipeInput;
import cubex2.cs3.ingame.gui.control.ButtonUpDown;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.control.Label;
import cubex2.cs3.ingame.gui.control.PictureBox;
import cubex2.cs3.ingame.gui.control.RecipeInputDisplay;
import cubex2.cs3.lib.Textures;
import cubex2.cs3.util.RecipeInput;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class WindowEditOrCreateShapedRecipe
extends WindowEditOrCreate<ShapedRecipe>
implements IWindowClosedListener {
    private RecipeInputDisplay[] inputDisplays;
    private ItemDisplay resultDisplay;
    private PictureBox pbArrow;
    private ButtonUpDown btnIncrAmount;
    private ButtonUpDown btnDecrAmount;
    private Label lblWidth;
    private Label lblHeight;

    public WindowEditOrCreateShapedRecipe(BaseContentPack pack) {
        super("New Shaped Recipe", 180, 150, pack);
    }

    public WindowEditOrCreateShapedRecipe(ShapedRecipe recipe, BaseContentPack pack) {
        super("Edit Shaped Recipe", 180, 150, recipe, pack);
    }

    @Override
    protected void initControls() {
        int col;
        int row;
        int i;
        this.inputDisplays = new RecipeInputDisplay[9];
        for (i = 0; i < 9; ++i) {
            row = i / 3;
            col = i % 3;
            this.inputDisplays[i] = ((RecipeInputDisplay)this.recipeInputDisplay().left(33 + col * 18).top(10 + row * 18).add()).setDrawSlotBackground();
            this.inputDisplays[i].setClearOnRightClick();
        }
        this.resultDisplay = ((ItemDisplay)this.itemDisplay().left(121).top(28).add()).setDrawSlotBackground();
        this.resultDisplay.setClearOnRightClick();
        this.btnIncrAmount = (ButtonUpDown)this.buttonUp().left(138).top(27).add();
        this.btnDecrAmount = (ButtonUpDown)this.buttonDown().left(138).top(36).add();
        if (this.editingContent != null) {
            for (i = 0; i < ((ShapedRecipe)this.editingContent).input.length; ++i) {
                row = i / ((ShapedRecipe)this.editingContent).width;
                col = i % ((ShapedRecipe)this.editingContent).width;
                this.inputDisplays[col + row * 3].setRecipeInput(((ShapedRecipe)this.editingContent).input[i]);
            }
            this.resultDisplay.setItemStack(((ShapedRecipe)this.editingContent).result);
        }
        this.pbArrow = (PictureBox)this.pictureBox(Textures.CONTROLS, 218, 18).left(93).top(28).size(22, 15).add();
        this.lblWidth = (Label)this.label("Width: 3").left(7).top(74).add();
        this.lblHeight = (Label)this.label("Height: 3").left(7).top(84).add();
        this.updateWidthAndHeight();
        this.updateButtons();
    }

    @Override
    protected ShapedRecipe createContent() {
        int[] minMax = this.getMinMax();
        int width = minMax[1] - minMax[0] + 1;
        int height = minMax[3] - minMax[2] + 1;
        ItemStack result = this.resultDisplay.getItemStack();
        RecipeInput[] inputs = new RecipeInput[width * height];
        for (int i = 0; i < inputs.length; ++i) {
            int row = i / width + minMax[2];
            int col = i % width + minMax[0];
            inputs[i] = this.inputDisplays[col + row * 3].getRecipeInput();
        }
        return new ShapedRecipe(width, height, inputs, result, this.pack);
    }

    @Override
    protected void editContent() {
        int[] minMax = this.getMinMax();
        int width = minMax[1] - minMax[0] + 1;
        int height = minMax[3] - minMax[2] + 1;
        ItemStack result = this.resultDisplay.getItemStack();
        RecipeInput[] inputs = new RecipeInput[width * height];
        for (int i = 0; i < inputs.length; ++i) {
            int row = i / width + minMax[2];
            int col = i % width + minMax[0];
            inputs[i] = this.inputDisplays[col + row * 3].getRecipeInput();
        }
        ((ShapedRecipe)this.editingContent).width = width;
        ((ShapedRecipe)this.editingContent).height = height;
        ((ShapedRecipe)this.editingContent).result = result;
        ((ShapedRecipe)this.editingContent).input = inputs;
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.resultDisplay) {
            GuiBase.openWindow(new WindowSelectItem(false), "result");
        } else if (c == this.btnIncrAmount) {
            int stackSize = this.resultDisplay.getItemStack().field_77994_a;
            stackSize = Math.min(this.resultDisplay.getItemStack().func_77976_d(), stackSize + (GuiBase.func_146272_n() ? 5 : 1));
            this.resultDisplay.setStackSize(stackSize);
            this.updateButtons();
        } else if (c == this.btnDecrAmount) {
            int stackSize = this.resultDisplay.getItemStack().field_77994_a;
            stackSize = Math.max(1, stackSize - (GuiBase.func_146272_n() ? 5 : 1));
            this.resultDisplay.setStackSize(stackSize);
            this.updateButtons();
        } else {
            int index = ArrayUtils.indexOf((Object[])this.inputDisplays, (Object)c);
            if (index != -1) {
                GuiBase.openWindow(new WindowSelectRecipeInput(this.pack), "" + index);
            } else {
                super.controlClicked(c, mouseX, mouseY);
            }
        }
    }

    private void updateButtons() {
        boolean validData = this.resultDisplay.getItemStack() != null;
        for (int i = 0; i < this.inputDisplays.length && this.inputDisplays[i].getRecipeInput() == null; ++i) {
            if (i != this.inputDisplays.length - 1) continue;
            validData = false;
        }
        if (this.editingContent == null) {
            this.btnCreate.setEnabled(validData);
        } else {
            this.btnEdit.setEnabled(validData);
        }
        ItemStack stack = this.resultDisplay.getItemStack();
        this.btnIncrAmount.setEnabled(stack != null && stack.field_77994_a < stack.func_77976_d());
        this.btnDecrAmount.setEnabled(stack != null && stack.field_77994_a > 1);
    }

    private void updateWidthAndHeight() {
        int[] minMax = this.getMinMax();
        int width = minMax[1] - minMax[0] + 1;
        int height = minMax[3] - minMax[2] + 1;
        this.lblWidth.setText("Width: " + width);
        this.lblHeight.setText("Height: " + height);
    }

    private int[] getMinMax() {
        int minX = 2;
        int maxX = 0;
        int minY = 2;
        int maxY = 0;
        for (int i = 0; i < this.inputDisplays.length; ++i) {
            if (this.inputDisplays[i].getRecipeInput() == null) continue;
            int row = i / 3;
            int col = i % 3;
            if (col < minX) {
                minX = col;
            }
            if (col > maxX) {
                maxX = col;
            }
            if (row < minY) {
                minY = row;
            }
            if (row <= maxY) continue;
            maxY = row;
        }
        return new int[]{minX, maxX, minY, maxY};
    }

    public void windowClosed(Window window) {
        if (window.tag.equals("result")) {
            WindowSelectItem w = (WindowSelectItem)window;
            if (w.getSelectedStack() != null) {
                this.resultDisplay.setItemStack(w.getSelectedStack());
                this.updateButtons();
            }
        } else {
            WindowSelectRecipeInput w = (WindowSelectRecipeInput)window;
            if (w.getSelectedInput() != null) {
                this.inputDisplays[Integer.parseInt(w.tag)].setRecipeInput(w.getSelectedInput());
                this.updateWidthAndHeight();
                this.updateButtons();
            }
        }
    }
}

