/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.OreDictionaryEntry;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.WindowEditOrCreate;
import cubex2.cs3.ingame.gui.WindowSelectItem;
import cubex2.cs3.ingame.gui.control.IValidityProvider;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.control.Label;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.lib.Validators;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class WindowEditOrCreateOreDictEntry
extends WindowEditOrCreate<OreDictionaryEntry>
implements IValidityProvider,
IWindowClosedListener<WindowSelectItem> {
    private ItemDisplay itemDisplay;
    private TextBox tbOreClass;
    private ItemDisplay[] itemDisplays;

    public WindowEditOrCreateOreDictEntry(BaseContentPack pack) {
        super("New Ore Dictionary Entry", 182, 201, pack);
    }

    public WindowEditOrCreateOreDictEntry(OreDictionaryEntry entry, BaseContentPack pack) {
        super("Edit Ore Dictionary Entry", 182, 201, entry, pack);
    }

    @Override
    protected void initControls() {
        this.row("Item:");
        this.itemDisplay = this.row(this.itemDisplay());
        this.row("Ore Class:");
        this.tbOreClass = this.row(this.textBox());
        Label label = this.row("Items in ore class:", 10);
        this.itemDisplay.useSelectItemDialog(false);
        this.itemDisplay.setValidatorFunc(Validators.ITEM_DISPLAY_NOT_NULL);
        this.itemDisplay.setDrawSlotBackground();
        if (this.editingContent != null) {
            this.itemDisplay.setItemStack(((OreDictionaryEntry)this.editingContent).stack);
        }
        this.tbOreClass.setValidityProvider(this);
        if (this.editingContent != null) {
            this.tbOreClass.setText(String.valueOf(((OreDictionaryEntry)this.editingContent).oreClass));
        }
        this.itemDisplays = new ItemDisplay[9];
        for (int i = 0; i < this.itemDisplays.length; ++i) {
            this.itemDisplays[i] = ((ItemDisplay)this.itemDisplay().left(7 + i * 19).top(label, 4).add()).setDrawSlotBackground();
        }
        this.updateItemDisplays();
    }

    @Override
    protected OreDictionaryEntry createContent() {
        ItemStack stack = this.itemDisplay.getItemStack();
        String oreClass = this.tbOreClass.getText().trim();
        return new OreDictionaryEntry(oreClass, stack, this.pack);
    }

    @Override
    protected void editContent() {
        ((OreDictionaryEntry)this.editingContent).stack = this.itemDisplay.getItemStack();
        ((OreDictionaryEntry)this.editingContent).oreClass = this.tbOreClass.getText().trim();
    }

    private void updateItemDisplays() {
        ArrayList ores = OreDictionary.getOres((String)this.tbOreClass.getText().trim());
        for (int i = 0; i < this.itemDisplays.length; ++i) {
            if (i < ores.size()) {
                this.itemDisplays[i].setItemStack(((ItemStack)ores.get(i)).func_77946_l());
                continue;
            }
            this.itemDisplays[i].setItemStack(null);
        }
    }

    @Override
    public String checkValidity(TextBox tb) {
        String message = null;
        String text = this.tbOreClass.getText().trim();
        if (text.length() == 0) {
            message = "Enter a value.";
        }
        this.updateItemDisplays();
        return message;
    }

    @Override
    public void windowClosed(WindowSelectItem window) {
        if (window.getSelectedStack() != null) {
            this.itemDisplay.setItemStack(window.getSelectedStack());
        }
    }
}

