/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import com.google.common.collect.Lists;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.MobSpawn;
import cubex2.cs3.ingame.gui.WindowEditOrCreate;
import cubex2.cs3.ingame.gui.control.ControlContainer;
import cubex2.cs3.ingame.gui.control.DropBox;
import cubex2.cs3.ingame.gui.control.NumericUpDown;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import cubex2.cs3.lib.Biomes;
import cubex2.cs3.util.GeneralHelper;
import java.util.ArrayList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;

public class WindowEditOrCreateMobSpawn
extends WindowEditOrCreate<MobSpawn> {
    private DropBox<String> dbMob;
    private DropBox<EnumCreatureType> dbType;
    private NumericUpDown nupRate;
    private NumericUpDown nupMin;
    private NumericUpDown nupMax;
    private ListBox<BiomeGenBase> lbBiomes;

    public WindowEditOrCreateMobSpawn(BaseContentPack pack) {
        super("New Mob Spawn", 180, 225, pack);
    }

    public WindowEditOrCreateMobSpawn(MobSpawn spawn, BaseContentPack pack) {
        super("Edit Mob Spawn", 180, 225, spawn, pack);
    }

    @Override
    protected void initControls() {
        this.row("Mob:");
        this.dbMob = (DropBox)((Object)this.row(this.dropBox(GeneralHelper.getMobNames())));
        this.dbMob.setSelectedValue("Creeper");
        this.row("Spawn Type:");
        this.dbType = (DropBox)this.row(this.dropBox(EnumCreatureType.values()));
        this.dbType.setSelectedValue(EnumCreatureType.monster);
        this.row("Rate:", "The spawn rate of the mob| 5 = witch| 8 = cow| 10 = enderman| 100 = zombie");
        this.nupRate = this.row(this.numericUpDown());
        this.nupRate.setMinValue(1);
        this.row("Min Count:", "1 = enderman|4 = creeper|8 = bat");
        ControlContainer c = (ControlContainer)this.row(this.container().height(20));
        this.nupMin = (NumericUpDown)c.col(c.numericUpDown().width(82), 3);
        this.nupMin.setValue(1);
        this.nupMax = (NumericUpDown)c.col(c.numericUpDown().width(81), 3);
        this.nupMax.setValue(1);
        this.label("Max Count:").left(this.nupMax, 0, true).bottom(this.nupMax, 4).add();
        this.infoButton("4 = enderman|4 = creeper|8 = bat").rightTo(this.lastControl).add();
        this.row("Biomes:");
        ListBoxDescription desc = new ListBoxDescription();
        desc.multiSelect = true;
        desc.elements = Biomes.getBiomes();
        desc.rows = 3;
        desc.sorted = true;
        desc.comparator = Biomes.COMPARATOR;
        this.lbBiomes = (ListBox)this.listBox(desc).below(this.lastControl).fillWidth(7).add();
        this.lbBiomes.disableGlobalScrolling();
        if (this.editingContent != null) {
            this.dbMob.setSelectedValue(((MobSpawn)this.editingContent).mob);
            this.dbType.setSelectedValue(((MobSpawn)this.editingContent).type);
            this.nupRate.setValue(((MobSpawn)this.editingContent).rate);
            this.nupMin.setValue(((MobSpawn)this.editingContent).min);
            this.nupMax.setValue(((MobSpawn)this.editingContent).max);
            this.lbBiomes.select(((MobSpawn)this.editingContent).biomes);
        } else {
            this.lbBiomes.select(Biomes.getBiomes());
        }
    }

    @Override
    protected MobSpawn createContent() {
        String mob = this.dbMob.getSelectedValue();
        EnumCreatureType type = this.dbType.getSelectedValue();
        int rate = this.nupRate.getValue();
        int min = this.nupMin.getValue();
        int max = this.nupMax.getValue();
        ArrayList biomes = Lists.newArrayList(this.lbBiomes.getSelectedItems());
        return new MobSpawn(mob, rate, min, max, type, biomes, this.pack);
    }

    @Override
    protected void editContent() {
        ((MobSpawn)this.editingContent).mob = this.dbMob.getSelectedValue();
        ((MobSpawn)this.editingContent).type = this.dbType.getSelectedValue();
        ((MobSpawn)this.editingContent).rate = this.nupRate.getValue();
        ((MobSpawn)this.editingContent).min = this.nupMin.getValue();
        ((MobSpawn)this.editingContent).max = this.nupMax.getValue();
        if (((MobSpawn)this.editingContent).max < ((MobSpawn)this.editingContent).min) {
            ((MobSpawn)this.editingContent).max = ((MobSpawn)this.editingContent).min;
        }
        ((MobSpawn)this.editingContent).biomes.clear();
        ((MobSpawn)this.editingContent).biomes.addAll(this.lbBiomes.getSelectedItems());
    }
}

