/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.MobDrop;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.WindowEditOrCreate;
import cubex2.cs3.ingame.gui.control.ButtonUpDown;
import cubex2.cs3.ingame.gui.control.CheckBox;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.DropBox;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.lib.TextBoxValidators;
import cubex2.cs3.lib.Validators;
import cubex2.cs3.util.GeneralHelper;
import net.minecraft.util.MathHelper;

public class WindowEditOrCreateMobDrop
extends WindowEditOrCreate<MobDrop>
implements IWindowClosedListener {
    private DropBox<String> dbMob;
    private ItemDisplay display;
    private TextBox tbChance;
    private CheckBox cbPlayerKillOnly;
    private ButtonUpDown btnUp;
    private ButtonUpDown btnDown;

    public WindowEditOrCreateMobDrop(BaseContentPack pack) {
        super("New Mob Drop", 180, 225, pack);
    }

    public WindowEditOrCreateMobDrop(MobDrop drop, BaseContentPack pack) {
        super("Edit Mob Drop", 180, 225, drop, pack);
    }

    @Override
    protected void initControls() {
        this.row("Mob:");
        this.dbMob = (DropBox)((Object)this.row(this.dropBox(GeneralHelper.getMobNames())));
        this.dbMob.setSelectedValue("Creeper");
        this.row("Item:");
        this.display = this.row(this.itemDisplay());
        this.display.setDrawSlotBackground();
        this.display.setValidatorFunc(Validators.ITEM_DISPLAY_NOT_NULL);
        this.display.useSelectItemDialog(false);
        this.btnUp = this.buttonUp().rightTo(this.display).add();
        this.btnDown = this.buttonDown().rightTo(this.display).add();
        this.row("Chance:");
        this.tbChance = this.row(this.textBox());
        this.tbChance.setValidityProvider(TextBoxValidators.FLOAT_ZERO_ONE);
        this.cbPlayerKillOnly = (CheckBox)this.row(this.checkBox("player kill only").width(10));
        if (this.editingContent != null) {
            this.dbMob.setSelectedValue(((MobDrop)this.editingContent).mob);
            this.display.setItemStack(((MobDrop)this.editingContent).stack.func_77946_l());
            this.tbChance.setText(String.valueOf(((MobDrop)this.editingContent).chance));
            this.cbPlayerKillOnly.setIsChecked(((MobDrop)this.editingContent).playerKillOnly);
        } else {
            this.tbChance.setText("1.0");
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.btnUp.setEnabled(this.display.getItemStack() != null && this.display.getItemStack().field_77994_a < this.display.getItemStack().func_77976_d());
        this.btnDown.setEnabled(this.display.getItemStack() != null && this.display.getItemStack().field_77994_a > 1);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnUp || c == this.btnDown) {
            int numChange = (GuiBase.func_146272_n() ? 5 : 1) * (c == this.btnUp ? 1 : -1);
            this.display.setStackSize(MathHelper.func_76125_a((int)(this.display.getItemStack().field_77994_a + numChange), (int)1, (int)this.display.getItemStack().func_77976_d()));
            this.updateButtons();
        } else {
            super.controlClicked(c, mouseX, mouseY);
        }
    }

    @Override
    protected MobDrop createContent() {
        return new MobDrop(this.dbMob.getSelectedValue(), this.display.getItemStack(), Float.parseFloat(this.tbChance.getText()), this.cbPlayerKillOnly.getIsChecked(), this.pack);
    }

    @Override
    protected void editContent() {
        ((MobDrop)this.editingContent).mob = this.dbMob.getSelectedValue();
        ((MobDrop)this.editingContent).stack = this.display.getItemStack();
        ((MobDrop)this.editingContent).chance = Float.parseFloat(this.tbChance.getText());
        ((MobDrop)this.editingContent).playerKillOnly = this.cbPlayerKillOnly.getIsChecked();
    }

    public void windowClosed(Window window) {
        this.updateButtons();
    }
}

