/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.GrassPlant;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.WindowEditOrCreate;
import cubex2.cs3.ingame.gui.WindowSelectBlock;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.control.NumericUpDown;
import cubex2.cs3.lib.Validators;

public class WindowEditOrCreateGrassPlant
extends WindowEditOrCreate<GrassPlant>
implements IWindowClosedListener<WindowSelectBlock> {
    private ItemDisplay blockDisplay;
    private NumericUpDown nupWeight;

    public WindowEditOrCreateGrassPlant(BaseContentPack pack) {
        super("New Grass Plant", 180, 103, pack);
    }

    public WindowEditOrCreateGrassPlant(GrassPlant editingPlant, BaseContentPack pack) {
        super("Edit Grass Plant", 180, 103, editingPlant, pack);
    }

    @Override
    protected void initControls() {
        this.row("Block:");
        this.blockDisplay = this.row(this.itemDisplay());
        this.blockDisplay.setValidatorFunc(Validators.ITEM_DISPLAY_NOT_NULL);
        if (this.editingContent == null) {
            this.blockDisplay.useSelectBlockDialog();
        } else {
            this.blockDisplay.setItemStack(((GrassPlant)this.editingContent).block);
        }
        this.blockDisplay.setDrawSlotBackground();
        this.row("Weight:", "The weight of the plant| 10 = red flowers| 20 = yellow flowers");
        this.nupWeight = this.row(this.numericUpDown());
        this.nupWeight.setMinValue(1);
        this.nupWeight.setValue(this.editingContent == null ? 1 : ((GrassPlant)this.editingContent).weight);
    }

    @Override
    protected GrassPlant createContent() {
        return new GrassPlant(this.blockDisplay.getItemStack(), this.nupWeight.getValue(), this.pack);
    }

    @Override
    protected void editContent() {
        ((GrassPlant)this.editingContent).weight = this.nupWeight.getValue();
    }

    @Override
    public void windowClosed(WindowSelectBlock window) {
        if (window.getSelectedStack() != null) {
            this.blockDisplay.setItemStack(window.getSelectedStack());
        }
    }
}

