/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import com.google.common.collect.Lists;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.Fuel;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.WindowEditOrCreate;
import cubex2.cs3.ingame.gui.WindowSelectString;
import cubex2.cs3.ingame.gui.control.Button;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.control.NumericUpDown;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.lib.TextBoxValidators;
import cubex2.cs3.lib.Validators;
import cubex2.cs3.registry.FuelRegistry;
import net.minecraft.item.ItemStack;

public class WindowEditOrCreateFuel
extends WindowEditOrCreate<Fuel>
implements IWindowClosedListener<Window> {
    private ItemDisplay itemDisplay;
    private NumericUpDown nupDuration;
    private TextBox tbFuelList;
    private Button btnSelectList;

    public WindowEditOrCreateFuel(BaseContentPack pack) {
        super("New Fuel", 180, 135, pack);
    }

    public WindowEditOrCreateFuel(Fuel fuel, BaseContentPack pack) {
        super("Edit Fuel", 180, 135, fuel, pack);
    }

    @Override
    protected void initControls() {
        this.row("Item:");
        this.itemDisplay = this.row(this.itemDisplay());
        this.row("Duration:", "The duration in ticks|(20 ticks = 1 second)| 100 = stick| 300 = wood| 1600 = coal|");
        this.nupDuration = this.row(this.numericUpDown());
        this.nupDuration.setValue(300);
        this.itemDisplay.setDrawSlotBackground();
        this.itemDisplay.useSelectItemDialog(false);
        this.itemDisplay.setValidatorFunc(Validators.ITEM_DISPLAY_NOT_NULL);
        this.label("Fuel List:").left(7).top(this.nupDuration, 8).add();
        if (this.editingContent != null) {
            this.itemDisplay.setItemStack(((Fuel)this.editingContent).stack);
            this.nupDuration.setValue(((Fuel)this.editingContent).duration);
            this.tbFuelList = (TextBox)this.textBox().below(this.lastControl).fillWidth(7).add();
            this.tbFuelList.setText(((Fuel)this.editingContent).fuelList);
        } else {
            this.tbFuelList = (TextBox)this.textBox().below(this.lastControl).left(7).right(70).add();
            this.tbFuelList.setText("vanilla");
            this.btnSelectList = (Button)this.button("Select").rightTo(this.tbFuelList).add();
        }
        this.tbFuelList.setValidityProvider(TextBoxValidators.NOT_EMPTY);
        this.tbFuelList.setEnabled(this.editingContent == null);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnSelectList) {
            Object[] fuelLists = ((FuelRegistry)this.pack.getContentRegistry(Fuel.class)).getFuelLists();
            GuiBase.openWindow(new WindowSelectString("Select Fuel List", Lists.newArrayList((Object[])fuelLists)));
        } else {
            super.controlClicked(c, mouseX, mouseY);
        }
    }

    @Override
    protected Fuel createContent() {
        ItemStack stack = this.itemDisplay.getItemStack();
        int duration = this.nupDuration.getValue();
        return new Fuel(this.tbFuelList.getText(), stack, duration, this.pack);
    }

    @Override
    protected void editContent() {
        ((Fuel)this.editingContent).stack = this.itemDisplay.getItemStack();
        ((Fuel)this.editingContent).duration = this.nupDuration.getValue();
    }

    @Override
    public void windowClosed(Window window) {
        WindowSelectString wdw;
        if (window instanceof WindowSelectString && (wdw = (WindowSelectString)window).getSelectedElement() != null) {
            this.tbFuelList.setText(wdw.getSelectedElement());
        }
    }
}

