/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.DungeonMob;
import cubex2.cs3.ingame.gui.WindowEditOrCreate;
import cubex2.cs3.ingame.gui.control.DropBox;
import cubex2.cs3.ingame.gui.control.NumericUpDown;
import cubex2.cs3.util.GeneralHelper;

public class WindowEditOrCreateDungeonMob
extends WindowEditOrCreate<DungeonMob> {
    private DropBox<String> dbMob;
    private NumericUpDown nupRarity;

    public WindowEditOrCreateDungeonMob(BaseContentPack pack) {
        super("New Dungeon Mob", 180, 105, pack);
    }

    public WindowEditOrCreateDungeonMob(DungeonMob editingMob, BaseContentPack pack) {
        super("Edit Dungeon Mob", 180, 105, editingMob, pack);
    }

    @Override
    protected void initControls() {
        this.row("Mob:");
        this.dbMob = (DropBox)((Object)this.row(this.dropBox(GeneralHelper.getMobNames())));
        this.row("Rarity:", "A higher value makes the|mob more common.| 100 = spider / skeleton| 200 = zombie");
        this.nupRarity = this.row(this.numericUpDown());
        this.nupRarity.setMinValue(1);
        if (this.editingContent != null) {
            this.dbMob.setSelectedValue(((DungeonMob)this.editingContent).mob);
            this.nupRarity.setValue(((DungeonMob)this.editingContent).rarity);
        } else {
            this.dbMob.setSelectedValue("Creeper");
            this.nupRarity.setValue(100);
        }
    }

    @Override
    protected DungeonMob createContent() {
        String mob = this.dbMob.getSelectedValue();
        int rarity = this.nupRarity.getValue();
        return new DungeonMob(mob, rarity, this.pack);
    }

    @Override
    protected void editContent() {
        ((DungeonMob)this.editingContent).mob = this.dbMob.getSelectedValue();
        ((DungeonMob)this.editingContent).rarity = this.nupRarity.getValue();
    }
}

