/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.CreativeTab;
import cubex2.cs3.ingame.gui.WindowEditOrCreate;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.lib.Validators;
import net.minecraft.item.ItemStack;

public class WindowEditOrCreateCreativeTab
extends WindowEditOrCreate<CreativeTab> {
    private TextBox tbName;
    private TextBox tbLabel;
    private ItemDisplay display;

    public WindowEditOrCreateCreativeTab(BaseContentPack pack) {
        super("New Creative Tab", 180, 128, pack);
    }

    public WindowEditOrCreateCreativeTab(CreativeTab editingTab, BaseContentPack pack) {
        super("Edit Creative Tab", 180, 128, editingTab, pack);
    }

    @Override
    protected void initControls() {
        this.row("Name:", "The internal name. Has to be unique.");
        this.tbName = this.row(this.textBox());
        this.row("Label:", "This is the actual text displayed.");
        this.tbLabel = this.row(this.textBox());
        this.row("Icon:");
        this.display = this.row(this.itemDisplay());
        this.display.setDrawSlotBackground();
        this.display.useSelectItemDialog(false);
        this.display.setValidatorFunc(Validators.ITEM_DISPLAY_NOT_NULL);
        if (this.editingContent != null) {
            this.tbName.setText(((CreativeTab)this.editingContent).name);
            this.tbName.setEnabled(false);
            this.tbLabel.setText(((CreativeTab)this.editingContent).label);
            this.display.setItemStack(((CreativeTab)this.editingContent).icon);
        }
    }

    @Override
    protected CreativeTab createContent() {
        String name = this.tbName.getText();
        String label = this.tbLabel.getText();
        ItemStack icon = this.display.getItemStack();
        return new CreativeTab(name, label, icon, this.pack);
    }

    @Override
    protected void editContent() {
        ((CreativeTab)this.editingContent).label = this.tbLabel.getText();
        ((CreativeTab)this.editingContent).icon = this.display.getItemStack();
    }
}

