/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.ChestItem;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.WindowEditOrCreate;
import cubex2.cs3.ingame.gui.WindowSelectItem;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.DropBox;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.control.NumericUpDown;
import cubex2.cs3.lib.Validators;
import cubex2.cs3.util.GeneralHelper;
import net.minecraft.item.ItemStack;

public class WindowEditOrCreateChestItem
extends WindowEditOrCreate<ChestItem>
implements IWindowClosedListener<WindowSelectItem> {
    private DropBox<String> dbChest;
    private ItemDisplay itemDisplay;
    private NumericUpDown nupMinCount;
    private NumericUpDown nupMaxCount;
    private NumericUpDown nupRarity;

    public WindowEditOrCreateChestItem(BaseContentPack pack) {
        super("New Chest Item", 180, 205, pack);
    }

    public WindowEditOrCreateChestItem(ChestItem item, BaseContentPack pack) {
        super("Edit Chest Item", 180, 205, item, pack);
    }

    @Override
    protected void initControls() {
        this.row("Chest:");
        this.dbChest = (DropBox)((Object)this.row(this.dropBox(GeneralHelper.getChestGenNames())));
        this.dbChest.setSelectedValue("bonusChest");
        this.row("Item:");
        this.itemDisplay = this.row(this.itemDisplay());
        this.itemDisplay.setDrawSlotBackground();
        this.itemDisplay.setValidatorFunc(Validators.ITEM_DISPLAY_NOT_NULL);
        this.row("Min Count:");
        this.nupMinCount = this.row(this.numericUpDown());
        this.nupMinCount.setMinValue(1);
        this.row("Max Count:");
        this.nupMaxCount = this.row(this.numericUpDown());
        this.nupMaxCount.setMinValue(1);
        this.row("Rarity:", "1 = golden apple (dungeon)|3 = stone axe (bonus)|10 = iron ingot (blacksmith)");
        this.nupRarity = this.row(this.numericUpDown());
        this.nupRarity.setValue(1);
        if (this.editingContent != null) {
            this.dbChest.setSelectedValue(((ChestItem)this.editingContent).chest);
            this.itemDisplay.setItemStack(((ChestItem)this.editingContent).stack);
            this.nupMinCount.setValue(((ChestItem)this.editingContent).minCount);
            this.nupMaxCount.setValue(((ChestItem)this.editingContent).maxCount);
            this.nupRarity.setValue(((ChestItem)this.editingContent).rarity);
        }
    }

    @Override
    protected ChestItem createContent() {
        String chest = this.dbChest.getSelectedValue();
        ItemStack stack = this.itemDisplay.getItemStack();
        int minCount = this.nupMinCount.getValue();
        int maxCount = this.nupMaxCount.getValue();
        if (maxCount < minCount) {
            maxCount = minCount;
        }
        int rarity = this.nupRarity.getValue();
        return new ChestItem(stack, chest, minCount, maxCount, rarity, this.pack);
    }

    @Override
    protected void editContent() {
        ((ChestItem)this.editingContent).chest = this.dbChest.getSelectedValue();
        ((ChestItem)this.editingContent).stack = this.itemDisplay.getItemStack();
        ((ChestItem)this.editingContent).minCount = this.nupMinCount.getValue();
        ((ChestItem)this.editingContent).maxCount = this.nupMaxCount.getValue();
        if (((ChestItem)this.editingContent).maxCount < ((ChestItem)this.editingContent).minCount) {
            ((ChestItem)this.editingContent).maxCount = ((ChestItem)this.editingContent).minCount;
        }
        ((ChestItem)this.editingContent).rarity = this.nupRarity.getValue();
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.itemDisplay) {
            GuiBase.openWindow(new WindowSelectItem());
        } else {
            super.controlClicked(c, mouseX, mouseY);
        }
    }

    @Override
    public void windowClosed(WindowSelectItem window) {
        if (window.getSelectedStack() != null) {
            this.itemDisplay.setItemStack(window.getSelectedStack());
        }
        this.btnCreate.setEnabled(this.itemDisplay.getItemStack() != null);
    }
}

