/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.WrappedItem;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.DropBox;
import cubex2.cs3.ingame.gui.control.IStringProvider;
import cubex2.cs3.ingame.gui.control.IValidityProvider;
import cubex2.cs3.ingame.gui.control.Label;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.item.EnumItemType;

public class WindowCreateItem
extends Window
implements IValidityProvider,
IStringProvider<EnumItemType> {
    private BaseContentPack pack;
    private Label lblName;
    private TextBox tbName;
    private Label lblType;
    private DropBox<EnumItemType> dbType;
    private Label lblInfo;

    public WindowCreateItem(BaseContentPack pack) {
        super("New Item", 10, 180, 201);
        this.pack = pack;
        this.lblName = (Label)this.label("Name:").at(7, 7).add();
        this.tbName = (TextBox)this.textBox().below(this.lblName).size(166, 17).add();
        this.lblType = (Label)this.label("Type:").below(this.tbName, 5).add();
        this.dbType = (DropBox)this.dropBox(EnumItemType.values()).below(this.lblType).size(100, 15).add();
        this.lblInfo = (Label)this.label("You need to restart Minecraft\nin order to use or edit this item.").below(this.dbType, 10).add();
        this.tbName.setValidityProvider(this);
        this.dbType.setSelectedValue(EnumItemType.NORMAL);
        this.dbType.setStringProvider(this);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCreate) {
            WrappedItem item = new WrappedItem(this.tbName.getText().trim(), this.dbType.getSelectedValue(), this.pack);
            item.apply();
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    public String checkValidity(TextBox tb) {
        String message = null;
        String text = tb.getText().trim();
        if (text.length() == 0) {
            message = "Enter a name";
        } else {
            for (WrappedItem item : this.pack.getContentRegistry(WrappedItem.class).getContentList()) {
                if (!item.getName().equals(text)) continue;
                message = "There is already a item with this name.";
                break;
            }
        }
        this.btnCreate.setEnabled(message == null);
        return message;
    }

    @Override
    public String getStringFor(EnumItemType value) {
        return value.name;
    }
}

