/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.GrassSeed;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.WindowSelectItem;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ItemDisplay;
import cubex2.cs3.ingame.gui.control.NumericUpDown;
import cubex2.cs3.lib.Validators;

public class WindowCreateGrassSeed
extends Window
implements IWindowClosedListener<WindowSelectItem> {
    private final BaseContentPack pack;
    private ItemDisplay itemDisplay;
    private NumericUpDown nupWeight;

    public WindowCreateGrassSeed(BaseContentPack pack) {
        super("New Grass Seed", 10, 180, 103);
        this.pack = pack;
        this.row("Item:");
        this.itemDisplay = this.row(this.itemDisplay());
        this.itemDisplay.setValidatorFunc(Validators.ITEM_DISPLAY_NOT_NULL);
        this.itemDisplay.useSelectItemDialog(false);
        this.itemDisplay.setDrawSlotBackground();
        this.row("Weight:", "The weight of the seed| 10 = vanilla seeds");
        this.nupWeight = this.row(this.numericUpDown());
        this.nupWeight.setMinValue(1);
        this.nupWeight.setValue(1);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCreate) {
            GrassSeed seed = new GrassSeed(this.itemDisplay.getItemStack(), this.nupWeight.getValue(), this.pack);
            seed.apply();
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    public void windowClosed(WindowSelectItem window) {
        if (window.getSelectedStack() != null) {
            this.itemDisplay.setItemStack(window.getSelectedStack());
        }
    }
}

