/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.block.EnumBlockType;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.WrappedBlock;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.DropBox;
import cubex2.cs3.ingame.gui.control.IStringProvider;
import cubex2.cs3.ingame.gui.control.IValidityProvider;
import cubex2.cs3.ingame.gui.control.Label;
import cubex2.cs3.ingame.gui.control.TextBox;

public class WindowCreateBlock
extends Window
implements IValidityProvider,
IStringProvider<EnumBlockType> {
    private final BaseContentPack pack;
    private Label lblName;
    private TextBox tbName;
    private Label lblType;
    private DropBox<EnumBlockType> dbType;
    private Label lblInfo;

    public WindowCreateBlock(BaseContentPack pack) {
        super("New Block", 10, 180, 201);
        this.pack = pack;
        this.lblName = (Label)this.label("Name:").at(7, 7).add();
        this.tbName = (TextBox)this.textBox().below(this.lblName).size(166, 17).add();
        this.lblType = (Label)this.label("Type:").below(this.tbName, 5).add();
        this.dbType = (DropBox)this.dropBox(EnumBlockType.values()).below(this.lblType).size(100, 15).add();
        this.lblInfo = (Label)this.label("You need to restart Minecraft\nin order to use or edit this block.").below(this.dbType, 10).add();
        this.tbName.setValidityProvider(this);
        this.dbType.setStringProvider(this);
        this.dbType.setSelectedValue(EnumBlockType.NORMAL);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCreate) {
            WrappedBlock block = new WrappedBlock(this.tbName.getText().trim(), this.dbType.getSelectedValue(), this.pack);
            block.apply();
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    @Override
    public String checkValidity(TextBox tb) {
        String message = null;
        String text = tb.getText().trim();
        if (text.length() == 0) {
            message = "Enter a name";
        } else {
            for (WrappedBlock block : this.pack.getContentRegistry(WrappedBlock.class).getContentList()) {
                if (!block.getName().equals(text)) continue;
                message = "There is already a block with this name.";
                break;
            }
        }
        return message;
    }

    @Override
    public String getStringFor(EnumBlockType value) {
        return value.name;
    }
}

