/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.common.ArmorMaterial;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ControlContainer;
import cubex2.cs3.ingame.gui.control.NumericUpDown;
import cubex2.cs3.ingame.gui.control.TextBox;
import cubex2.cs3.lib.TextBoxValidators;

public class WindowCreateArmorMaterial
extends Window {
    private final BaseContentPack pack;
    private TextBox tbName;
    private NumericUpDown nupDurability;
    private NumericUpDown nupEnchantability;
    private NumericUpDown[] nupReduceAmounts;

    public WindowCreateArmorMaterial(BaseContentPack pack) {
        super("New Armor Material", 10, 180, 195);
        this.pack = pack;
        this.row("Name:");
        this.tbName = this.row(this.textBox());
        this.tbName.setValidityProvider(TextBoxValidators.NEW_ARMOR_MATERIAL_NAME);
        this.row("Durability:", "The actual durability is this|multiplied with these values:|Helmet: 11|Plate: 16|Legs: 15|Boots: 13");
        ControlContainer c = (ControlContainer)this.row(this.container().height(20));
        this.nupDurability = (NumericUpDown)c.col(c.numericUpDown().width(82), 3);
        this.nupDurability.setMinValue(1);
        this.nupDurability.setValue(1);
        this.nupEnchantability = (NumericUpDown)c.col(c.numericUpDown().width(81), 3);
        this.label("Enchantability:").left(this.nupEnchantability, 0, true).bottom(this.nupEnchantability, 4).add();
        this.row("Reduction Amounts", "Each 1 point is half a shield", 11);
        String[] names = new String[]{"Helmet", "Plate", "Legs", "Boots"};
        this.nupReduceAmounts = new NumericUpDown[4];
        for (int i = 0; i < 4; i += 2) {
            this.row(names[i] + ":");
            c = (ControlContainer)this.row(this.container().height(20));
            this.nupReduceAmounts[i] = (NumericUpDown)c.col(c.numericUpDown().width(82), 3);
            this.nupReduceAmounts[i].setValue(1);
            this.nupReduceAmounts[i].setMinValue(1);
            this.nupReduceAmounts[i + 1] = (NumericUpDown)c.col(c.numericUpDown().width(81), 3);
            this.nupReduceAmounts[i + 1].setValue(1);
            this.nupReduceAmounts[i + 1].setMinValue(1);
            this.label(names[i + 1] + ":").left(this.nupReduceAmounts[i + 1], 0, true).bottom(this.nupReduceAmounts[i + 1], 4).add();
        }
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnCreate) {
            int[] amounts = new int[4];
            for (int i = 0; i < 4; ++i) {
                amounts[i] = this.nupReduceAmounts[i].getValue();
            }
            ArmorMaterial material = new ArmorMaterial(this.tbName.getText(), this.nupDurability.getValue(), this.nupEnchantability.getValue(), amounts, this.pack);
            material.apply();
            GuiBase.openPrevWindow();
        } else {
            this.handleDefaultButtonClick(c);
        }
    }
}

