/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import cubex2.cs3.common.BaseContent;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.listbox.IListBoxItemClickListener;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;

public abstract class WindowContentList<T extends BaseContent>
extends Window
implements IListBoxItemClickListener<T>,
IWindowClosedListener {
    protected final BaseContentPack pack;
    protected ListBox<T> listBox;
    protected final Class<T> clazz;

    public WindowContentList(Class<T> clazz, String title, int width, int height, BaseContentPack pack) {
        this(clazz, title, 53, width, height, pack);
    }

    public WindowContentList(Class<T> clazz, String title, int buttons, int width, int height, BaseContentPack pack) {
        super(title, buttons, width, height);
        this.clazz = clazz;
        this.pack = pack;
        ListBoxDescription desc = new ListBoxDescription(7, 7);
        desc.elements = pack.getContentRegistry(clazz).getContentList();
        desc.canSelect = true;
        this.modifyListBoxDesc(desc);
        this.listBox = (ListBox)this.listBox(desc).fillWidth(7).top(7).add();
        if (this.btnEdit != null) {
            this.btnEdit.setEnabled(false);
        }
        this.btnDelete.setEnabled(false);
    }

    protected abstract void modifyListBoxDesc(ListBoxDescription<T> var1);

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        if (c == this.btnNew) {
            GuiBase.openWindow(this.createNewContentWindow());
        } else if (c == this.btnEdit && this.btnEdit != null) {
            GuiBase.openWindow(this.createEditContentWindow((BaseContent)this.listBox.getSelectedItem()));
        } else if (c == this.btnDelete) {
            ((BaseContent)this.listBox.getSelectedItem()).remove();
            this.listBox.updateElements(this.pack.getContentRegistry(this.clazz).getContentList());
            this.btnDelete.setEnabled(false);
            if (this.btnEdit != null) {
                this.btnEdit.setEnabled(false);
            }
        } else {
            this.handleDefaultButtonClick(c);
        }
    }

    protected abstract Window createNewContentWindow();

    protected abstract Window createEditContentWindow(T var1);

    public void windowClosed(Window window) {
        this.listBox.updateElements(this.pack.getContentRegistry(this.clazz).getContentList());
        this.btnDelete.setEnabled(false);
        if (this.btnEdit != null) {
            this.btnEdit.setEnabled(false);
        }
    }

    @Override
    public void itemClicked(T item, ListBox<T> listBox, int button) {
        if (this.btnEdit != null) {
            this.btnEdit.setEnabled(listBox.getSelectedIndex() != -1 && ((BaseContent)listBox.getSelectedItem()).canEdit());
        }
        this.btnDelete.setEnabled(listBox.getSelectedIndex() != -1);
    }
}

