/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import com.google.common.collect.Lists;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.control.Button;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.ingame.gui.control.ControlContainer;
import cubex2.cs3.ingame.gui.control.IValidityControl;
import cubex2.cs3.ingame.gui.control.IValueListener;
import cubex2.cs3.lib.Textures;
import cubex2.cs3.util.GuiHelper;
import java.util.List;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class Window
extends ControlContainer
implements IValueListener {
    protected static final int BACK = 1;
    protected static final int CANCEL = 2;
    protected static final int NEW = 4;
    protected static final int CREATE = 8;
    protected static final int DELETE = 16;
    protected static final int EDIT = 32;
    protected static final int SELECT = 64;
    public String title;
    public String tag = null;
    public boolean drawSlots = false;
    protected Button btnBack;
    protected Button btnCancel;
    protected Button btnNew;
    protected Button btnCreate;
    protected Button btnEdit;
    protected Button btnDelete;
    protected Button btnSelect;
    protected Button btnPlus;
    protected boolean drawBackground = true;
    private final int usedControls;
    private Control focusedControl = null;
    public List<Control> tabStopControls = Lists.newArrayList();
    private List<IValidityControl> validityControls = Lists.newArrayList();

    public Window(int width, int height) {
        this(null, 0, width, height);
    }

    public Window(int usedControls, int width, int height) {
        this(null, usedControls, width, height);
    }

    public Window(String title, int width, int height) {
        this(title, 0, width, height);
    }

    public Window(String title, int usedControls, int width, int height) {
        super(width, height, null, 0, 0, null);
        this.usedControls = usedControls;
        this.title = title;
        this.init();
    }

    private void init() {
        this.controls.clear();
        this.validityControls.clear();
        if ((this.usedControls & 1) == 1) {
            this.btnBack = (Button)this.button(this.underline("Back", 2)).right(7).bottom(7).add();
        }
        if ((this.usedControls & 2) == 2) {
            this.btnCancel = (Button)this.button(this.underline("Cancel", 0)).right(7).bottom(7).add();
        }
        if ((this.usedControls & 0x40) == 64) {
            this.btnSelect = (Button)this.button(this.underline("Select", 0)).left(7).bottom(7).add();
        }
        int xOffset = 0;
        if ((this.usedControls & 4) == 4) {
            this.btnNew = (Button)this.button(this.underline("New", 0)).left(7 + xOffset).bottom(7).add();
            xOffset += 63;
        }
        if ((this.usedControls & 8) == 8) {
            this.btnCreate = (Button)this.button(this.underline("Create", 1)).left(7 + xOffset).bottom(7).add();
            xOffset += 63;
        }
        if ((this.usedControls & 0x20) == 32) {
            this.btnEdit = (Button)this.button(this.underline("Edit", 0)).left(7 + xOffset).bottom(7).add();
            xOffset += 63;
        }
        if ((this.usedControls & 0x10) == 16) {
            this.btnDelete = (Button)this.button(this.underline("Delete", 0)).left(7 + xOffset).bottom(7).add();
            xOffset += 63;
        }
    }

    private String underline(String s, int pos) {
        return s.substring(0, pos) + "\u00a7n" + s.substring(pos, pos + 1) + "\u00a7r" + s.substring(pos + 1);
    }

    public void addValidityControl(IValidityControl vc) {
        this.validityControls.add(vc);
        vc.setValueChangedListener(this);
    }

    @Override
    public void keyTyped(char c, int key) {
        if (key == 18 && Keyboard.isKeyDown((int)56)) {
            if (this.btnEdit != null && this.btnEdit.isEnabled()) {
                this.handleDefaultButtonClick(this.btnEdit);
            }
        } else if (key == 46 && Keyboard.isKeyDown((int)56)) {
            if (this.btnCancel != null && this.btnCancel.isEnabled()) {
                this.handleDefaultButtonClick(this.btnCancel);
            } else if (this.btnBack != null && this.btnBack.isEnabled()) {
                this.handleDefaultButtonClick(this.btnBack);
            }
        } else if (key == 32 && Keyboard.isKeyDown((int)56)) {
            if (this.btnDelete != null && this.btnDelete.isEnabled()) {
                this.controlClicked(this.btnDelete, this.btnDelete.getX() + 1, this.btnDelete.getY() + 1);
            }
        } else if (key == 49 && Keyboard.isKeyDown((int)56)) {
            if (this.btnNew != null && this.btnNew.isEnabled()) {
                this.controlClicked(this.btnNew, this.btnNew.getX() + 1, this.btnNew.getY() + 1);
            }
        } else if (key == 19 && Keyboard.isKeyDown((int)56)) {
            if (this.btnCreate != null && this.btnCreate.isEnabled()) {
                this.controlClicked(this.btnCreate, this.btnCreate.getX() + 1, this.btnCreate.getY() + 1);
            }
        } else if (key == 31 && Keyboard.isKeyDown((int)56)) {
            if (this.btnSelect != null && this.btnSelect.isEnabled()) {
                this.controlClicked(this.btnSelect, this.btnSelect.getX() + 1, this.btnSelect.getY() + 1);
            }
        } else if (key == 15) {
            if (this.tabStopControls.isEmpty()) {
                return;
            }
            Control next = this.focusedControl == null || !this.tabStopControls.contains(this.focusedControl) ? this.tabStopControls.get(0) : this.tabStopControls.get((this.tabStopControls.indexOf(this.focusedControl) + 1) % this.tabStopControls.size());
            this.claimFocus(next);
        } else {
            super.keyTyped(c, key);
        }
    }

    public Control getFocusedControl() {
        return this.focusedControl;
    }

    public boolean claimFocus(Control c) {
        if (this.focusedControl != null && !this.focusedControl.canReleaseFocus()) {
            return false;
        }
        if (this.focusedControl != null) {
            this.focusedControl.onUnfocus();
        }
        this.focusedControl = c;
        if (this.focusedControl != null) {
            this.focusedControl.onFocus();
        }
        return true;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button, boolean intoControl) {
        this.claimFocus(null);
        super.mouseClicked(mouseX, mouseY, button, intoControl);
    }

    @Override
    protected void controlClicked(Control c, int mouseX, int mouseY) {
        this.handleDefaultButtonClick(c);
    }

    protected void handleDefaultButtonClick(Control c) {
        if (c == this.btnBack) {
            GuiBase.openPrevWindow();
        } else if (c == this.btnCancel) {
            GuiBase.openPrevWindow();
        } else if (c == this.btnEdit) {
            this.handleEditButtonClicked();
        }
    }

    protected void handleEditButtonClicked() {
    }

    public void onValueChanged(Control c) {
        this.updateValidation();
    }

    protected void updateValidation() {
        boolean allValidValues = true;
        for (IValidityControl c : this.validityControls) {
            if (c.hasValidValue()) continue;
            allValidValues = false;
            break;
        }
        if (this.btnCreate != null) {
            this.btnCreate.setEnabled(allValidValues);
        }
        if (this.btnEdit != null) {
            this.btnEdit.setEnabled(allValidValues);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float renderTick) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.drawBackground) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71446_o.func_110577_a(Textures.BG);
            GuiHelper.drawRectSliced(this.bounds, 0, 0, 256, 256);
        }
        if (this.title != null) {
            this.mc.field_71446_o.func_110577_a(Textures.CONTROLS2);
            int width = this.mc.field_71466_p.func_78256_a(this.title) + 14;
            this.drawTexturedModalRect(this.bounds.getX() + (this.bounds.getWidth() - width) / 2, this.bounds.getY() - 15, 156, 0, width / 2, 18);
            this.drawTexturedModalRect(this.bounds.getX() + (this.bounds.getWidth() - width) / 2 + width / 2, this.bounds.getY() - 15, 256 - width / 2, 0, width / 2, 18);
            this.mc.field_71466_p.func_78276_b(this.title, this.bounds.getX() + (this.bounds.getWidth() - this.mc.field_71466_p.func_78256_a(this.title)) / 2, this.bounds.getY() - 10, -16777216);
        }
        super.draw(mouseX, mouseY, renderTick);
    }

    public void onGuiClosed() {
    }
}

