/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.gui;

import com.google.common.collect.Lists;
import cubex2.cs3.gui.WindowNormal;
import cubex2.cs3.ingame.gui.GuiContainerBase;
import cubex2.cs3.ingame.gui.IWindowClosedListener;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.WindowContainer;
import cubex2.cs3.ingame.gui.WindowMain;
import cubex2.cs3.ingame.gui.control.Control;
import cubex2.cs3.util.GuiHelper;
import java.util.ArrayList;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.entity.RenderItem;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.Rectangle;

public class GuiBase
extends GuiScreen {
    public static GuiBase INSTANCE;
    public static final RenderItem itemRenderer;
    public static int dWheel;
    public final Stack<Window> windowHistory = new Stack();
    public Window window;
    public static boolean devMode;
    public static Control activeDevControl;
    public static Control inputLockedControl;
    public static boolean isContainerGuiOpen;
    static GuiContainerBase containerGui;
    public static int tickCounter;

    private GuiBase() {
        INSTANCE = this;
        Control.ROOT_CONTROL_DUMMY.onParentResized();
        this.window = new WindowMain();
    }

    public static void init() {
    }

    public static void closeGui() {
        GuiBase.INSTANCE.field_146297_k.func_147108_a((GuiScreen)null);
        GuiBase.INSTANCE.field_146297_k.func_71381_h();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public static <T extends WindowContainer> GuiContainerBase createContainerGui(T window) {
        GuiContainerBase gui = new GuiContainerBase(window, window.getContainer());
        isContainerGuiOpen = true;
        containerGui = gui;
        return gui;
    }

    public static void openWindow(Window window) {
        GuiBase.openWindow(window, null);
    }

    public static void openWindow(Window window, String tag) {
        window.tag = tag;
        GuiBase.INSTANCE.windowHistory.push(GuiBase.INSTANCE.window);
        GuiBase.INSTANCE.window = window;
        GuiBase.INSTANCE.window.onParentResized();
    }

    public static void openPrevWindow() {
        Window currentWindow = GuiBase.INSTANCE.window;
        GuiBase.INSTANCE.window = GuiBase.INSTANCE.windowHistory.pop();
        GuiBase.INSTANCE.window.onParentResized();
        if (GuiBase.INSTANCE.window instanceof IWindowClosedListener && !(currentWindow instanceof WindowNormal)) {
            ((IWindowClosedListener)((Object)GuiBase.INSTANCE.window)).windowClosed(currentWindow);
        }
    }

    public static void lockInput(Control c) {
        inputLockedControl = c;
    }

    public static void releaseInput() {
        inputLockedControl = null;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        Control.ROOT_CONTROL_DUMMY.onParentResized();
        this.window.onParentResized();
    }

    public void func_146281_b() {
        if (this.window != null) {
            this.window.onGuiClosed();
        }
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        ++tickCounter;
        dWheel = Mouse.getDWheel() / 120;
        this.window.onUpdate();
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        boolean intoWindow = this.window.isMouseOverControl(mouseX, mouseY);
        if (devMode) {
            if (button == 0) {
                activeDevControl = this.window.getControlAt(mouseX, mouseY);
            }
        } else {
            this.window.mouseClicked(mouseX, mouseY, button, intoWindow);
            if (intoWindow) {
                this.window.mouseDown(mouseX, mouseY, button);
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int button) {
        if (!devMode) {
            this.window.mouseUp(mouseX, mouseY, button);
        }
    }

    protected void func_73869_a(char c, int i) {
        if (i == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
            this.field_146297_k.func_71381_h();
        } else if (i == 65) {
            boolean bl = devMode = !devMode;
            if (!devMode) {
                activeDevControl = null;
            }
        }
        if (devMode) {
            if (activeDevControl != null) {
                if (i == 208) {
                    ++GuiBase.activeDevControl.offsetY;
                    activeDevControl.onParentResized();
                } else if (i == 200) {
                    --GuiBase.activeDevControl.offsetY;
                    activeDevControl.onParentResized();
                }
                if (i == 203) {
                    --GuiBase.activeDevControl.offsetX;
                    activeDevControl.onParentResized();
                } else if (i == 205) {
                    ++GuiBase.activeDevControl.offsetX;
                    activeDevControl.onParentResized();
                }
                if (i == 201) {
                    activeDevControl = activeDevControl.getParent();
                }
            }
        } else {
            this.window.keyTyped(c, i);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float renderTick) {
        this.window.draw(mouseX, mouseY, renderTick);
        this.window.drawForeground(mouseX, mouseY);
        if (devMode) {
            this.drawDevScreen(mouseX, mouseY);
        }
    }

    private void drawDevScreen(int mouseX, int mouseY) {
        this.field_146297_k.field_71466_p.func_78276_b("Dev Mode", 5, 5, -65536);
        Control c = this.window.getControlAt(mouseX, mouseY);
        if (c != null) {
            ArrayList list = Lists.newArrayList();
            list.add(c.getClass().getSimpleName());
            list.add(String.format("X: %d Y: %d", c.getX(), c.getY()));
            list.add("W: " + c.getWidth() + " H: " + c.getHeight());
            GuiHelper.drawHoveringText(list, mouseX, mouseY, this.field_146297_k.field_71466_p);
        }
        if (activeDevControl != null) {
            GuiHelper.drawBorder(activeDevControl.getX() - 1, activeDevControl.getY() - 1, activeDevControl.getX() + activeDevControl.getWidth() + 1, activeDevControl.getY() + activeDevControl.getHeight() + 1, -65536);
        }
    }

    public Rectangle getBounds() {
        if (Minecraft.func_71410_x().field_71462_r == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(0, 0, Minecraft.func_71410_x().field_71462_r.field_146294_l, Minecraft.func_71410_x().field_71462_r.field_146295_m);
    }

    public void func_73733_a(int x1, int y1, int x2, int y2, int color1, int color2) {
        super.func_73733_a(x1, y1, x2, y2, color1, color2);
    }

    public void setZLevel(float value) {
        this.field_73735_i = value;
    }

    static {
        new GuiBase();
        itemRenderer = new RenderItem();
        dWheel = 0;
        devMode = false;
        activeDevControl = null;
        inputLockedControl = null;
        isContainerGuiOpen = false;
    }
}

