/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.ingame.docs;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cubex2.cs3.api.scripting.TriggerType;
import cubex2.cs3.ingame.docs.NamedLink;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.ingame.gui.common.WindowDocs;
import cubex2.cs3.ingame.gui.control.ControlContainer;
import cubex2.cs3.ingame.gui.control.ScrollContainer;
import cubex2.cs3.ingame.gui.control.listbox.ListBox;
import cubex2.cs3.ingame.gui.control.listbox.ListBoxDescription;
import cubex2.cs3.lib.Scripts;
import cubex2.cs3.util.ClientHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ParsedDocFile {
    private static final Map<String, ParsedDocFile> docs = Maps.newHashMap();
    public String title;
    private List<DocElement> elements = Lists.newArrayList();
    private List<NamedLink> listBoxElements = Lists.newArrayList();
    private String type = "default";
    private boolean sorted = false;
    private boolean maxWidth = false;
    public String path = "";

    public static ParsedDocFile fromPath(String path) {
        return ParsedDocFile.fromPath(path, true);
    }

    public static ParsedDocFile fromPath(String path, boolean useCache) {
        if (useCache && docs.containsKey(path)) {
            return docs.get(path);
        }
        ParsedDocFile doc = ParsedDocFile.fromString(ClientHelper.loadDocFile(path), path);
        docs.put(path, doc);
        return doc;
    }

    public static ParsedDocFile fromString(String contents, String path) {
        ParsedDocFile doc = new ParsedDocFile(path);
        String elemPrefix = "";
        String[] lines = contents.split("\n");
        boolean isText = false;
        String text = "";
        for (String line : lines) {
            String[] parts;
            if (!isText) {
                line = line.trim();
            }
            if (isText && line.startsWith("}--")) {
                if (text.endsWith("\n")) {
                    text = text.substring(0, text.length() - 1);
                }
                doc.elements.add(new DocLabel(text));
                text = "";
                isText = false;
                continue;
            }
            if (isText) {
                line = line.endsWith("\\") ? line.substring(0, line.length() - 1) : line + "\n";
                text = text + line;
                continue;
            }
            if (line.startsWith("TEXT --{")) {
                isText = true;
                continue;
            }
            if (line.startsWith("BUTTON")) {
                parts = ParsedDocFile.parseLine(line);
                doc.elements.add(new DocButton(parts[1], parts.length > 2 ? parts[2] + ".txt" : ""));
                continue;
            }
            if (line.startsWith("SCRIPT_OBJECTS")) {
                String[] objects;
                parts = ParsedDocFile.parseLine(line);
                for (String obj : objects = Scripts.getInfo((String)parts[1], (TriggerType)TriggerType.valueOf((String)parts[2])).availableObjects) {
                    doc.elements.add(new DocButton(obj, "script/" + obj + ".txt"));
                }
                continue;
            }
            if (line.startsWith("TITLE")) {
                doc.title = line.substring(line.indexOf(32) + 1);
                continue;
            }
            if (line.startsWith("TYPE")) {
                doc.type = line.substring(line.indexOf(32) + 1);
                continue;
            }
            if (line.startsWith("ELEM_PREFIX")) {
                elemPrefix = ParsedDocFile.parseLine(line)[1];
                continue;
            }
            if (line.startsWith("ELEM")) {
                parts = ParsedDocFile.parseLine(line);
                String link = parts.length >= 3 ? elemPrefix + parts[2] + ".txt" : null;
                doc.listBoxElements.add(new NamedLink(parts[1], link, parts.length >= 4 && parts[3].equals("TRUE")));
                continue;
            }
            if (line.startsWith("SORTED")) {
                doc.sorted = true;
                continue;
            }
            if (!line.startsWith("MAX_WIDTH")) continue;
            doc.maxWidth = true;
        }
        return doc;
    }

    private static String[] parseLine(String line) {
        ArrayList ret = Lists.newArrayList();
        line = line.trim();
        String current = "";
        boolean insideString = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\\') {
                current = current + line.charAt(i + 1);
                ++i;
                continue;
            }
            if (c == '\"') {
                if (insideString) {
                    ret.add(current);
                    current = "";
                }
                insideString = !insideString;
                continue;
            }
            if (c == ' ' && !insideString) {
                if (current.length() <= 0) continue;
                ret.add(current);
                current = "";
                continue;
            }
            current = current + c;
        }
        if (current.length() > 0) {
            ret.add(current);
        }
        return ret.toArray(new String[ret.size()]);
    }

    private ParsedDocFile(String path) {
        this.path = path;
    }

    public int getWidth() {
        if (this.maxWidth) {
            return Math.min(GuiBase.INSTANCE.field_146294_l, 504);
        }
        return 256;
    }

    public void add(WindowDocs window) {
        if (this.title != null && this.title.length() > 0) {
            window.title = this.title;
        }
        if (this.type.equals("default")) {
            ScrollContainer scroll = (ScrollContainer)window.scrollContainer(1).fillWidth(7).top(7).bottom(window.getBackButton(), 5).add();
            ControlContainer content = scroll.content();
            for (DocElement element : this.elements) {
                element.add(this, window, content);
            }
            scroll.automaticTotalHeight();
        } else if (this.type.equals("list")) {
            ListBoxDescription desc = new ListBoxDescription(7, 7);
            desc.elements = this.listBoxElements;
            desc.canSelect = false;
            desc.rows = 12;
            desc.sorted = this.sorted;
            ListBox listBox = (ListBox)window.listBox(desc).fillWidth(7).top(7).add();
        }
    }

    private static class DocButton
    implements DocElement {
        private String text;
        private String path;

        public DocButton(String text, String path) {
            this.text = text;
            this.path = path;
        }

        @Override
        public void add(ParsedDocFile docFile, WindowDocs window, ControlContainer content) {
            content.row(content.buttonDoc(this.text, this.path).size(100, 13), true);
        }
    }

    private static class DocLabel
    implements DocElement {
        private String text;

        private DocLabel(String text) {
            this.text = text;
        }

        @Override
        public void add(ParsedDocFile docFile, WindowDocs window, ControlContainer content) {
            content.row(content.label(Joiner.on((char)'\n').join((Iterable)window.mc.field_71466_p.func_78271_c(this.text, docFile.getWidth() - 14 - 3 - 12))), true);
        }
    }

    private static interface DocElement {
        public void add(ParsedDocFile var1, WindowDocs var2, ControlContainer var3);
    }
}

