/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.handler;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cubex2.cs3.common.TradeRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.village.MerchantRecipeList;

public class VillageTradeHandler
implements VillagerRegistry.IVillageTradeHandler {
    public static final VillageTradeHandler INSTANCE = new VillageTradeHandler();
    private final Map<Integer, List<TradeRecipe>> recipes = Maps.newHashMap();

    private VillageTradeHandler() {
    }

    public void addRecipe(TradeRecipe recipe) {
        int villagerType = recipe.profession;
        if (!this.recipes.containsKey(villagerType)) {
            this.recipes.put(villagerType, new ArrayList());
            VillagerRegistry.instance().registerVillageTradeHandler(villagerType, (VillagerRegistry.IVillageTradeHandler)INSTANCE);
        }
        if (!this.recipes.get(villagerType).contains(recipe)) {
            this.recipes.get(villagerType).add(recipe);
        }
    }

    public void removeRecipe(TradeRecipe recipe) {
        if (this.recipes.containsKey(recipe.profession)) {
            this.recipes.get(recipe.profession).remove(recipe);
        }
    }

    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
        if (this.recipes.containsKey(villager.func_70946_n())) {
            for (TradeRecipe recipe : this.recipes.get(villager.func_70946_n())) {
                if (!(random.nextFloat() < recipe.chance)) continue;
                recipeList.add((Object)recipe.recipe);
            }
        }
    }
}

