/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.gui.data;

import com.google.common.collect.Lists;
import cubex2.cs3.gui.data.ButtonData;
import cubex2.cs3.gui.data.ControlData;
import cubex2.cs3.gui.data.CookProgressData;
import cubex2.cs3.gui.data.FuelProgressData;
import cubex2.cs3.gui.data.LabelData;
import cubex2.cs3.gui.data.PlayerInventoryData;
import cubex2.cs3.gui.data.SlotData;
import cubex2.cs3.util.MyFunction;
import cubex2.cs3.util.NBTData;
import cubex2.cs3.util.Util;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class GuiData
implements NBTData {
    public List<ControlData> controls = Lists.newArrayList();
    private static final MyFunction<NBTTagCompound, ControlData> READER = new MyFunction<NBTTagCompound, ControlData>(){

        @Override
        public ControlData apply(NBTTagCompound compound) {
            String type = compound.func_74779_i("ControlType");
            ControlData data = null;
            if (type.equals("button")) {
                data = new ButtonData();
            } else if (type.equals("label")) {
                data = new LabelData();
            } else if (type.equals("playerInventory")) {
                data = new PlayerInventoryData();
            } else if (type.equals("invSlot")) {
                data = new SlotData();
            } else if (type.equals("cookProgress")) {
                data = new CookProgressData();
            } else if (type.equals("fuelProgress")) {
                data = new FuelProgressData();
            }
            ((ControlData)data).readFromNBT(compound);
            return data;
        }
    };

    public void add(ControlData data) {
        this.controls.add(data);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        Util.writeListToNBT("Controls", this.controls, compound);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        Util.readListFromNBT("Controls", this.controls, READER, compound);
    }

    public int getSlotIndex(SlotData data) {
        int index = -1;
        for (ControlData cd : this.controls) {
            if (cd instanceof SlotData) {
                ++index;
            }
            if (cd != data) continue;
            break;
        }
        return index;
    }

    public int numSlots() {
        int num = 0;
        for (ControlData c : this.controls) {
            if (!(c instanceof SlotData)) continue;
            ++num;
        }
        return num;
    }
}

