/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.gui;

import cubex2.cs3.common.WrappedGui;
import cubex2.cs3.gui.InventoryItemStack;
import cubex2.cs3.gui.SlotFurnaceOutput;
import cubex2.cs3.gui.attributes.GuiContainerAttributes;
import cubex2.cs3.gui.data.ControlData;
import cubex2.cs3.gui.data.GuiData;
import cubex2.cs3.gui.data.PlayerInventoryData;
import cubex2.cs3.gui.data.ShiftClickRule;
import cubex2.cs3.gui.data.SlotData;
import cubex2.cs3.tileentity.TileEntityInventory;
import cubex2.cs3.tileentity.data.FurnaceModule;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerBasic
extends Container {
    private final WrappedGui gui;
    private final EntityPlayer player;
    private final IInventory slotInv;
    private final GuiContainerAttributes container;
    private final boolean isTile;
    private int[] lastCookTimes;
    private int[] lastBurnTimes;
    private int[] lastCurrentBurnTimes;

    public ContainerBasic(WrappedGui gui, EntityPlayer player, IInventory slotInv) {
        this.gui = gui;
        this.container = (GuiContainerAttributes)gui.container;
        this.player = player;
        this.slotInv = slotInv;
        this.isTile = slotInv instanceof TileEntityInventory;
        if (this.isTile) {
            int num = ((TileEntityInventory)slotInv).getContainer().furnaceModules.list.size();
            this.lastCookTimes = new int[num];
            this.lastBurnTimes = new int[num];
            this.lastCurrentBurnTimes = new int[num];
        }
        final boolean isStackInv = slotInv instanceof InventoryItemStack;
        GuiData data = gui.container.guiData;
        int nextSlot = 0;
        for (int iter = 0; iter < 2; ++iter) {
            for (ControlData cData : data.controls) {
                int i;
                if (iter == 0 && cData instanceof SlotData) {
                    SlotData slotData = (SlotData)cData;
                    if (slotData.furnaceOutput) {
                        this.func_75146_a(new SlotFurnaceOutput(gui.getPack(), slotData.recipeList, player, slotInv, nextSlot++, cData.x + 1, cData.y + 1));
                        continue;
                    }
                    this.func_75146_a(new Slot(slotInv, nextSlot++, cData.x + 1, cData.y + 1));
                    continue;
                }
                if (iter != 1 || !(cData instanceof PlayerInventoryData)) continue;
                for (i = 0; i < 3; ++i) {
                    for (int j = 0; j < 9; ++j) {
                        this.func_75146_a(new Slot((IInventory)player.field_71071_by, j + (i + 1) * 9, cData.x + 1 + j * 18, cData.y + 1 + i * 18));
                    }
                }
                for (i = 0; i < 9; ++i) {
                    this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, cData.x + 1 + i * 18, cData.y + 59){

                        public boolean func_82869_a(EntityPlayer player) {
                            return !isStackInv || player.field_71071_by.func_70448_g() != this.func_75211_c();
                        }
                    });
                }
            }
        }
    }

    public void func_75132_a(ICrafting crafting) {
        super.func_75132_a(crafting);
        if (this.isTile) {
            TileEntityInventory tile = (TileEntityInventory)this.slotInv;
            List modules = tile.getContainer().furnaceModules.list;
            for (int i = 0; i < modules.size(); ++i) {
                TileEntityInventory.FurnaceData data = tile.getFurnaceData((FurnaceModule)modules.get(i));
                crafting.func_71112_a((Container)this, i * 3, data.cookTime);
                crafting.func_71112_a((Container)this, i * 3 + 1, data.burnTime);
                crafting.func_71112_a((Container)this, i * 3 + 2, data.currentBurnTime);
            }
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.isTile) {
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                ICrafting icrafting = (ICrafting)this.field_75149_d.get(i);
                TileEntityInventory tile = (TileEntityInventory)this.slotInv;
                List modules = tile.getContainer().furnaceModules.list;
                for (int j = 0; j < modules.size(); ++j) {
                    TileEntityInventory.FurnaceData data = tile.getFurnaceData((FurnaceModule)modules.get(j));
                    if (this.lastCookTimes[j] != data.cookTime) {
                        icrafting.func_71112_a((Container)this, j * 3, data.cookTime);
                    }
                    if (this.lastBurnTimes[j] != data.burnTime) {
                        icrafting.func_71112_a((Container)this, j * 3 + 1, data.burnTime);
                    }
                    if (this.lastCurrentBurnTimes[j] != data.currentBurnTime) {
                        icrafting.func_71112_a((Container)this, j * 3 + 2, data.currentBurnTime);
                    }
                    this.lastCookTimes[j] = data.cookTime;
                    this.lastBurnTimes[j] = data.burnTime;
                    this.lastCurrentBurnTimes[j] = data.currentBurnTime;
                }
            }
        }
    }

    public void func_75137_b(int id, int value) {
        super.func_75137_b(id, value);
        if (this.isTile) {
            int moduleNr = id / 3;
            TileEntityInventory tile = (TileEntityInventory)this.slotInv;
            TileEntityInventory.FurnaceData data = tile.getFurnaceData((FurnaceModule)tile.getContainer().furnaceModules.list.get(moduleNr));
            if ((id %= 3) == 0) {
                data.cookTime = value;
            } else if (id == 1) {
                data.burnTime = value;
            } else if (id == 2) {
                data.currentBurnTime = value;
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            boolean ruleApplied = false;
            for (ShiftClickRule rule : this.container.shiftClickRules.list) {
                if (rule.fuelOnly && !this.gui.getPack().fuelHandler.isItemFuel(itemstack1, rule.fuelList) || rule.furnaceInputOnly && this.gui.getPack().smeltingRecipeHandler.getSmeltingResult(itemstack1, rule.recipeList) == null) continue;
                int start = rule.fromStart;
                int end = rule.fromEnd;
                if (rule.fromInv) {
                    start += this.slotInv.func_70302_i_();
                    end += this.slotInv.func_70302_i_();
                }
                if (slotIndex < start || slotIndex > end) continue;
                start = rule.toStart;
                end = rule.toEnd;
                if (rule.toInv) {
                    start += this.slotInv.func_70302_i_();
                    end += this.slotInv.func_70302_i_();
                }
                ruleApplied = true;
                boolean reverse = start > end;
                if (this.func_75135_a(itemstack1, reverse ? end : start, reverse ? start + 1 : end + 1, reverse)) break;
                return null;
            }
            if (!ruleApplied) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, itemstack1);
        }
        return itemstack;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.slotInv.func_70296_d();
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.slotInv.func_70300_a(player);
    }
}

