/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common.scripting;

import cpw.mods.fml.common.eventhandler.Event;
import cubex2.cs3.api.scripting.ITriggerData;
import cubex2.cs3.api.scripting.TriggerType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TriggerData
implements ITriggerData {
    private String triggerName;
    private String blockName;
    private TriggerType triggerType;
    private World world;
    private Integer x;
    private Integer y;
    private Integer z;
    private EntityPlayer player;
    private EntityPlayer interactPlayer;
    private EntityLivingBase living;
    private EntityItem item;
    private Entity entity;
    private ItemStack itemStack;
    private Float hitX;
    private Float hitY;
    private Integer side;
    private Integer slotId;
    private Integer tickCount;
    private Boolean isCurrentItem;
    private Boolean redstoneSignal;
    private Integer mouseX;
    private Integer mouseY;
    private Integer guiX;
    private Integer guiY;
    private Integer width;
    private Integer height;
    private IInventory craftMatrix;
    private Event event;

    public TriggerData(String name, TriggerType type) {
        this.triggerName = name;
        this.triggerType = type;
    }

    public TriggerData(String name, TriggerType type, World world, int x, int y, int z) {
        this(name, type);
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public TriggerData(String name, TriggerType type, World world, EntityPlayer player, ItemStack itemStack) {
        this(name, type);
        this.world = world;
        this.player = player;
        this.itemStack = itemStack;
    }

    @Override
    public String getTriggerName() {
        return this.triggerName;
    }

    @Override
    public String getBlockName() {
        return this.blockName;
    }

    @Override
    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Integer getPositionX() {
        return this.x;
    }

    @Override
    public Integer getPositionY() {
        return this.y;
    }

    @Override
    public Integer getPositionZ() {
        return this.z;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public EntityPlayer getInteractPlayer() {
        return this.interactPlayer;
    }

    @Override
    public EntityLivingBase getLiving() {
        return this.living;
    }

    @Override
    public EntityItem getItem() {
        return this.item;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public Float getHitX() {
        return this.hitX;
    }

    @Override
    public Float getHitY() {
        return this.hitY;
    }

    @Override
    public Integer getSide() {
        return this.side;
    }

    @Override
    public Integer getSlotId() {
        return this.slotId;
    }

    @Override
    public Integer getTickCount() {
        return this.tickCount;
    }

    @Override
    public Boolean getIsCurrentItem() {
        return this.isCurrentItem;
    }

    @Override
    public Boolean getRedstoneSignal() {
        return this.redstoneSignal;
    }

    @Override
    public Integer getMouseX() {
        return this.mouseX;
    }

    @Override
    public Integer getMouseY() {
        return this.mouseY;
    }

    @Override
    public Integer getGuiX() {
        return this.guiX;
    }

    @Override
    public Integer getGuiY() {
        return this.guiY;
    }

    @Override
    public Integer getWidth() {
        return this.width;
    }

    @Override
    public Integer getHeight() {
        return this.height;
    }

    @Override
    public IInventory getCraftMatrix() {
        return this.craftMatrix;
    }

    @Override
    public Event getEvent() {
        return this.event;
    }

    public TriggerData setTriggerName(String triggerName) {
        this.triggerName = triggerName;
        return this;
    }

    public TriggerData setTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
        return this;
    }

    public TriggerData setWorld(World world) {
        this.world = world;
        return this;
    }

    public TriggerData setPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public TriggerData setPlayer(EntityPlayer player) {
        this.player = player;
        return this;
    }

    public TriggerData setInteractPlayer(EntityPlayer interactPlayer) {
        this.interactPlayer = interactPlayer;
        return this;
    }

    public TriggerData setLiving(EntityLivingBase living) {
        this.living = living;
        return this;
    }

    public TriggerData setItem(EntityItem item) {
        this.item = item;
        return this;
    }

    public TriggerData setEntity(Entity entity) {
        this.entity = entity;
        return this;
    }

    public TriggerData setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
        return this;
    }

    public TriggerData setSide(int side) {
        this.side = side;
        return this;
    }

    public TriggerData setSideAndHit(int side, float hitX, float hitY, float hitZ) {
        int lookDir = MathHelper.func_76128_c((double)((double)(this.player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        this.side = side;
        if (side == 0 || side == 1) {
            switch (lookDir) {
                case 0: {
                    this.hitY = Float.valueOf(1.0f - hitZ);
                    this.hitX = Float.valueOf(1.0f - hitX);
                    break;
                }
                case 1: {
                    this.hitY = Float.valueOf(hitZ);
                    this.hitX = Float.valueOf(1.0f - hitZ);
                    break;
                }
                case 2: {
                    this.hitY = Float.valueOf(hitZ);
                    this.hitX = Float.valueOf(hitX);
                    break;
                }
                case 3: {
                    this.hitY = Float.valueOf(1.0f - hitZ);
                    this.hitX = Float.valueOf(hitZ);
                }
            }
        }
        switch (side) {
            case 0: {
                switch (lookDir) {
                    case 0: {
                        this.hitY = Float.valueOf(1.0f - hitZ);
                        this.hitX = Float.valueOf(1.0f - hitX);
                        break;
                    }
                    case 1: {
                        this.hitY = Float.valueOf(hitX);
                        this.hitX = Float.valueOf(1.0f - hitZ);
                        break;
                    }
                    case 2: {
                        this.hitY = Float.valueOf(hitZ);
                        this.hitX = Float.valueOf(hitX);
                        break;
                    }
                    case 3: {
                        this.hitY = Float.valueOf(1.0f - hitX);
                        this.hitX = Float.valueOf(hitZ);
                    }
                }
                break;
            }
            case 1: {
                switch (lookDir) {
                    case 0: {
                        this.hitY = Float.valueOf(hitZ);
                        this.hitX = Float.valueOf(1.0f - hitX);
                        break;
                    }
                    case 1: {
                        this.hitY = Float.valueOf(1.0f - hitX);
                        this.hitX = Float.valueOf(1.0f - hitZ);
                        break;
                    }
                    case 2: {
                        this.hitY = Float.valueOf(1.0f - hitZ);
                        this.hitX = Float.valueOf(hitX);
                        break;
                    }
                    case 3: {
                        this.hitY = Float.valueOf(hitX);
                        this.hitX = Float.valueOf(hitZ);
                    }
                }
                break;
            }
            case 2: {
                this.hitX = Float.valueOf(1.0f - hitX);
                this.hitY = Float.valueOf(hitY);
                break;
            }
            case 3: {
                this.hitX = Float.valueOf(hitX);
                this.hitY = Float.valueOf(hitY);
                break;
            }
            case 4: {
                this.hitX = Float.valueOf(hitZ);
                this.hitY = Float.valueOf(hitY);
                break;
            }
            case 5: {
                this.hitX = Float.valueOf(1.0f - hitZ);
                this.hitY = Float.valueOf(hitY);
            }
        }
        return this;
    }

    public TriggerData setBlockName(String blockName) {
        this.blockName = blockName;
        return this;
    }

    public TriggerData setSlotId(int slotId) {
        this.slotId = slotId;
        return this;
    }

    public TriggerData setTickCount(int tickCount) {
        this.tickCount = tickCount;
        return this;
    }

    public TriggerData setIsCurrentItem(boolean isCurrentItem) {
        this.isCurrentItem = isCurrentItem;
        return this;
    }

    public TriggerData setRedstoneSignal(boolean redstoneSignal) {
        this.redstoneSignal = redstoneSignal;
        return this;
    }

    public TriggerData setMousePosition(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        return this;
    }

    public TriggerData setGuiPosition(int guiX, int guiY) {
        this.guiX = guiX;
        this.guiY = guiY;
        return this;
    }

    public TriggerData setWidthAndHeight(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public TriggerData setCraftMatrix(IInventory craftMatrix) {
        this.craftMatrix = craftMatrix;
        return this;
    }

    public TriggerData setEvent(Event event) {
        this.event = event;
        return this;
    }
}

