/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common.scripting;

import com.google.common.collect.Lists;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.scripting.ScriptableEntity;
import cubex2.cs3.common.scripting.ScriptableInventory;
import cubex2.cs3.common.scripting.ScriptablePosition;
import cubex2.cs3.tileentity.TileEntityCS;
import cubex2.cs3.util.GeneralHelper;
import cubex2.cs3.util.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWall;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fluids.BlockFluidBase;

public class ScriptableWorld {
    public World world;

    public ScriptableWorld(World world) {
        this.world = world;
    }

    public void setMod(BaseContentPack mod) {
    }

    public void setBlock(ScriptablePosition position, String blockName) {
        this.setBlock((int)position.x, (int)position.y, (int)position.z, blockName);
    }

    public void setBlock(ScriptablePosition position, String blockName, boolean notifyNeighbors) {
        this.setBlock((int)position.x, (int)position.y, (int)position.z, blockName, notifyNeighbors);
    }

    public void setBlock(int x, int y, int z, String blockName) {
        this.setBlock(x, y, z, blockName, true);
    }

    public void setBlock(int x, int y, int z, String blockName, boolean notifyNeighbors) {
        Block block = GeneralHelper.getBlock(blockName);
        this.world.func_147449_b(x, y, z, block);
        if (notifyNeighbors) {
            this.world.func_147444_c(x, y, z, block);
        }
    }

    public void setBlockMetadata(ScriptablePosition position, int metadata) {
        this.setBlockMetadata((int)position.x, (int)position.y, (int)position.z, metadata);
    }

    public void setBlockMetadata(int x, int y, int z, int metadata) {
        this.world.func_72921_c(x, y, z, metadata, 3);
        this.world.func_147471_g(x, y, z);
    }

    public void setBlockAndMetadata(ScriptablePosition position, String blockName, int metadata) {
        this.setBlockAndMetadata((int)position.x, (int)position.y, (int)position.z, blockName, metadata);
    }

    public void setBlockAndMetadata(int x, int y, int z, String blockName, int metadata) {
        this.world.func_147465_d(x, y, z, GeneralHelper.getBlock(blockName), metadata, 3);
    }

    public void harvestBlock(ScriptablePosition position) {
        this.harvestBlock((int)position.x, (int)position.y, (int)position.z);
    }

    public void harvestBlock(int x, int y, int z) {
        new Random();
        Block block = this.world.func_147439_a(x, y, z);
        int damage = this.world.func_72805_g(x, y, z);
        ArrayList is = block.getDrops(this.world, x, y, z, damage, 0);
        this.world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.field_149762_H.func_150495_a(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
        this.world.func_147468_f(x, y, z);
        this.world.func_147444_c(x, y, z, Blocks.field_150350_a);
        float f = 0.7f;
        double d = (double)(this.world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(this.world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(this.world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        if (is.size() > 0) {
            for (ItemStack is1 : is) {
                if (is1.field_77994_a == 0 || this.world.field_72995_K) continue;
                EntityItem entityitem = new EntityItem(this.world, (double)x + d, (double)y + d1, (double)z + d2, new ItemStack(is1.func_77973_b(), is1.field_77994_a, is1.func_77960_j()));
                entityitem.field_145804_b = 10;
                this.world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public void setTime(long time) {
        this.world.func_72877_b(time);
    }

    public long getTime() {
        return this.world.func_72820_D();
    }

    public void createExplosion(ScriptablePosition position, float strength, boolean flaming) {
        this.createExplosion(position.x, position.y, position.z, strength, flaming);
    }

    public void createExplosion(double x, double y, double z, float strength, boolean flaming) {
        this.world.func_72885_a(null, x, y, z, strength, flaming, true);
    }

    public void createThunderbolt(ScriptablePosition position) {
        this.createThunderbolt(position.x, position.y, position.z);
    }

    public void createThunderbolt(double x, double y, double z) {
        EntityLightningBolt entitylightningbolt = new EntityLightningBolt(this.world, x, y, z);
        this.world.func_72838_d((Entity)entitylightningbolt);
    }

    public void spawnMob(ScriptablePosition position, String name) {
        this.spawnMob(position.x, position.y, position.z, name);
    }

    public void spawnMob(double x, double y, double z, String name) {
        if (!this.world.field_72995_K) {
            Entity entity = EntityList.func_75620_a((String)name, (World)this.world);
            entity.func_70012_b(x, y, z, this.world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            this.world.func_72838_d(entity);
        }
    }

    public void spawnItem(ScriptablePosition position, String itemName, int count, int damage) {
        this.spawnItem(position.x, position.y, position.z, itemName, count, damage);
    }

    public void spawnItem(double x, double y, double z, String itemName, int count, int damage) {
        if (this.world.field_72995_K) {
            return;
        }
        float f = 0.7f;
        double d = (double)(this.world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(this.world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(this.world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(this.world, x + d, y + d1, z + d2, new ItemStack(GeneralHelper.getItem(itemName), count, damage));
        entityitem.field_145804_b = 10;
        this.world.func_72838_d((Entity)entityitem);
    }

    public void setWeather(String weather, int duration) {
        if (weather.equals("sun")) {
            this.world.func_72912_H().func_76084_b(false);
            this.world.func_72912_H().func_76080_g(0);
            this.world.func_72912_H().func_76069_a(false);
            this.world.func_72912_H().func_76090_f(0);
        } else if (weather.equals("rain")) {
            this.world.func_72912_H().func_76084_b(true);
            this.world.func_72912_H().func_76080_g(duration);
            this.world.func_72912_H().func_76069_a(false);
            this.world.func_72912_H().func_76090_f(0);
        } else if (weather.equals("thundering")) {
            this.world.func_72912_H().func_76084_b(true);
            this.world.func_72912_H().func_76080_g(duration);
            this.world.func_72912_H().func_76069_a(true);
            this.world.func_72912_H().func_76090_f(duration);
        }
    }

    public boolean isRaining() {
        return this.world.func_72912_H().func_76059_o();
    }

    public boolean isThundering() {
        this.world.func_72911_I();
        return this.world.func_72912_H().func_76061_m();
    }

    public String getBlockName(ScriptablePosition position) {
        return this.getBlockName((int)position.x, (int)position.y, (int)position.z);
    }

    public String getBlockName(int x, int y, int z) {
        String name = GeneralHelper.getBlockName(this.world.func_147439_a(x, y, z));
        return name != null ? name : "minecraft:air";
    }

    public int getBlockMetadata(ScriptablePosition position) {
        return this.getBlockMetadata((int)position.x, (int)position.y, (int)position.z);
    }

    public int getBlockMetadata(int x, int y, int z) {
        return this.world.func_72805_g(x, y, z);
    }

    public String getBiome(ScriptablePosition position) {
        return this.getBiome((int)position.x, (int)position.y, (int)position.z);
    }

    public String getBiome(int x, int y, int z) {
        return this.world.func_72959_q().func_76935_a((int)x, (int)z).field_76791_y;
    }

    public void shear(ScriptablePosition position) {
        this.shear((int)position.x, (int)position.y, (int)position.z);
    }

    public void shear(int x, int y, int z) {
        IShearable target;
        Block block = this.world.func_147439_a(x, y, z);
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(null, (IBlockAccess)this.world, x, y, z)) {
            ArrayList drops = target.onSheared(null, (IBlockAccess)this.world, x, y, z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, null));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(this.world, (double)x + d, (double)y + d1, (double)z + d2, stack);
                entityitem.field_145804_b = 10;
                this.world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public int countEntities(ScriptablePosition pos1, ScriptablePosition pos2, String entities) {
        return this.countEntities(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z, entities);
    }

    public int countEntities(double x1, double y1, double z1, double x2, double y2, double z2, String entities) {
        AxisAlignedBB axis = AxisAlignedBB.func_72330_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        int amount = 0;
        for (String entity : entities.split(",")) {
            Object mobClass = entity.equals("hostile") ? EntityMob.class : (entity.equals("animal") ? EntityAnimal.class : (entity.equals("mob") ? EntityLiving.class : (entity.equals("player") ? EntityPlayer.class : (entity.equals("item") ? EntityItem.class : (entity.equals("all") ? null : (entity.matches("[0-9]+") ? (Class)EntityList.field_75625_b.get(EntityList.func_75617_a((int)Integer.parseInt(entity))) : (Class)EntityList.field_75625_b.get(entity)))))));
            amount += mobClass == null ? this.world.func_72839_b((Entity)null, axis).size() : this.world.func_72872_a(mobClass, axis).size();
        }
        return amount;
    }

    public ScriptableEntity[] enumEntities(ScriptablePosition pos1, ScriptablePosition pos2, String entities) {
        return this.enumEntities(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z, entities);
    }

    public ScriptableEntity[] enumEntities(double x1, double y1, double z1, double x2, double y2, double z2, String entities) {
        AxisAlignedBB axis = AxisAlignedBB.func_72330_a((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        ArrayList ret = Lists.newArrayList();
        for (String entity : entities.split(",")) {
            Class mobClass = null;
            if (entity.equals("hostile")) {
                mobClass = EntityMob.class;
            } else if (entity.equals("animal")) {
                mobClass = EntityAnimal.class;
            } else if (entity.equals("mob")) {
                mobClass = EntityLiving.class;
            } else if (entity.equals("player")) {
                mobClass = EntityPlayer.class;
            } else if (entity.equals("item")) {
                mobClass = EntityItem.class;
            } else {
                if (entity.equals("all")) continue;
                mobClass = entity.matches("[0-9]+") ? (Class)EntityList.field_75625_b.get(EntityList.func_75617_a((int)Integer.parseInt(entity))) : (Class)EntityList.field_75625_b.get(entity);
            }
            List list = mobClass == null ? this.world.func_72839_b((Entity)null, axis) : this.world.func_72872_a(mobClass, axis);
            for (Entity e : list) {
                ret.add(new ScriptableEntity(e));
            }
        }
        return ret.toArray(new ScriptableEntity[ret.size()]);
    }

    public int getBlockLightLevel(ScriptablePosition position) {
        return this.getBlockLightLevel((int)position.x, (int)position.y, (int)position.z);
    }

    public int getBlockLightLevel(int x, int y, int z) {
        return this.world.func_72957_l(x, y, z);
    }

    public void sendMessageToAllPlayers(String message) {
        if (!this.world.field_72995_K) {
            for (Object o : this.world.field_73010_i) {
                if (!(o instanceof EntityPlayer)) continue;
                ((EntityPlayer)o).func_146105_b((IChatComponent)new ChatComponentText(message));
            }
        }
    }

    public void sendMessageToPlayer(String player, String message) {
        EntityPlayer entityPlayer;
        if (!this.world.field_72995_K && (entityPlayer = this.world.func_72924_a(player)) != null) {
            entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(message));
        }
    }

    public String getBlockType(ScriptablePosition position) {
        return this.getBlockType((int)position.x, (int)position.y, (int)position.z);
    }

    public String getBlockType(int x, int y, int z) {
        Block block = this.world.func_147439_a(x, y, z);
        if (block == null) {
            return "unknown";
        }
        if (block instanceof BlockButton) {
            return "button";
        }
        if (block instanceof BlockCarpet) {
            return "carpet";
        }
        if (block instanceof BlockChest) {
            return "chest";
        }
        if (block instanceof BlockDoor) {
            return "door";
        }
        if (block instanceof BlockFence) {
            return "fence";
        }
        if (block instanceof BlockFenceGate) {
            return "fenceGate";
        }
        if (block instanceof BlockFluidBase) {
            return "fluid";
        }
        if (block instanceof BlockFurnace) {
            return "furnace";
        }
        if (block instanceof BlockLadder) {
            return "ladder";
        }
        if (block instanceof BlockPane) {
            return "pane";
        }
        if (block instanceof BlockBasePressurePlate) {
            return "pressurePlate";
        }
        if (block instanceof BlockSlab) {
            return "slab";
        }
        if (block instanceof BlockTorch) {
            return "torch";
        }
        if (block instanceof BlockTrapDoor) {
            return "trapDoor";
        }
        if (block instanceof BlockWall) {
            return "wall";
        }
        return "unknown";
    }

    public void spawnParticle(String name, ScriptablePosition position, double velX, double velY, double velZ) {
        this.spawnParticle(name, position.x, position.y, position.z, velX, velY, velZ);
    }

    public void spawnParticle(String name, double x, double y, double z, double velX, double velY, double velZ) {
        this.world.func_72869_a(name, x, y, z, velX, velY, velZ);
    }

    public ScriptableInventory getInventory(ScriptablePosition position) {
        return this.getInventory((int)position.x, (int)position.y, (int)position.z);
    }

    public ScriptableInventory getInventory(int x, int y, int z) {
        TileEntity te = this.world.func_147438_o(x, y, z);
        if (te != null & te instanceof IInventory) {
            return new ScriptableInventory((IInventory)te);
        }
        return null;
    }

    public int getTileEntityIntData(ScriptablePosition pos, String name) {
        return this.getTileEntityIntData((int)pos.x, (int)pos.y, (int)pos.z, name);
    }

    public int getTileEntityIntData(int x, int y, int z, String name) {
        TileEntity tileEntity = this.world.func_147438_o(x, y, z);
        if (tileEntity != null & tileEntity instanceof TileEntityCS) {
            TileEntityCS tile = (TileEntityCS)tileEntity;
            return NBTHelper.getCSIntData(tile.getCompound(), name);
        }
        return -1;
    }

    public float getTileEntityFloatData(ScriptablePosition pos, String name) {
        return this.getTileEntityFloatData((int)pos.x, (int)pos.y, (int)pos.z, name);
    }

    public float getTileEntityFloatData(int x, int y, int z, String name) {
        TileEntity tileEntity = this.world.func_147438_o(x, y, z);
        if (tileEntity != null & tileEntity instanceof TileEntityCS) {
            TileEntityCS tile = (TileEntityCS)tileEntity;
            return NBTHelper.getCSFloatData(tile.getCompound(), name);
        }
        return -1.0f;
    }

    public String getTileEntityStringData(ScriptablePosition pos, String name) {
        return this.getTileEntityStringData((int)pos.x, (int)pos.y, (int)pos.z, name);
    }

    public String getTileEntityStringData(int x, int y, int z, String name) {
        TileEntity tileEntity = this.world.func_147438_o(x, y, z);
        if (tileEntity != null & tileEntity instanceof TileEntityCS) {
            TileEntityCS tile = (TileEntityCS)tileEntity;
            return NBTHelper.getCSStringData(tile.getCompound(), name);
        }
        return null;
    }

    public void setTileEntityIntData(ScriptablePosition pos, String name, int data) {
        this.setTileEntityIntData((int)pos.x, (int)pos.y, (int)pos.z, name, data);
    }

    public void setTileEntityIntData(int x, int y, int z, String name, int data) {
        TileEntity tileEntity = this.world.func_147438_o(x, y, z);
        if (tileEntity != null & tileEntity instanceof TileEntityCS) {
            TileEntityCS tile = (TileEntityCS)tileEntity;
            NBTHelper.setCSIntData(tile.getCompound(), name, data);
        }
    }

    public void setTileEntityFloatData(ScriptablePosition pos, String name, float data) {
        this.setTileEntityFloatData((int)pos.x, (int)pos.y, (int)pos.z, name, data);
    }

    public void setTileEntityFloatData(int x, int y, int z, String name, float data) {
        TileEntity tileEntity = this.world.func_147438_o(x, y, z);
        if (tileEntity != null & tileEntity instanceof TileEntityCS) {
            TileEntityCS tile = (TileEntityCS)tileEntity;
            NBTHelper.setCSFloatData(tile.getCompound(), name, data);
        }
    }

    public void setTileEntityStringData(ScriptablePosition pos, String name, String data) {
        this.setTileEntityStringData((int)pos.x, (int)pos.y, (int)pos.z, name, data);
    }

    public void setTileEntityStringData(int x, int y, int z, String name, String data) {
        TileEntity tileEntity = this.world.func_147438_o(x, y, z);
        if (tileEntity != null & tileEntity instanceof TileEntityCS) {
            TileEntityCS tile = (TileEntityCS)tileEntity;
            NBTHelper.setCSStringData(tile.getCompound(), name, data);
        }
    }

    public void setTileEntityModel(ScriptablePosition position, String id, String obj) {
        this.setTileEntityModel((int)position.x, (int)position.y, (int)position.z, id, obj);
    }

    public void setTileEntityModel(int x, int y, int z, String id, String obj) {
        TileEntity tileEntity = this.world.func_147438_o(x, y, z);
        if (tileEntity != null & tileEntity instanceof TileEntityCS) {
            TileEntityCS tile = (TileEntityCS)tileEntity;
            tile.BModel = new ResourceLocation(id, obj);
        }
    }

    public void setTileEntityTexture(ScriptablePosition position, String id, String texture) {
        this.setTileEntityTexture((int)position.x, (int)position.y, (int)position.z, id, texture);
    }

    public void setTileEntityTexture(int x, int y, int z, String id, String texture) {
        TileEntity tileEntity = this.world.func_147438_o(x, y, z);
        if (tileEntity != null & tileEntity instanceof TileEntityCS) {
            TileEntityCS tile = (TileEntityCS)tileEntity;
            tile.BTexture = new ResourceLocation(id, texture);
        }
    }

    public void setTileEntityTrans(ScriptablePosition position, float tx, float ty, float tz) {
        this.setTileEntityTrans((int)position.x, (int)position.y, (int)position.y, tx, ty, tz);
    }

    public void setTileEntityTrans(int x, int y, int z, float tx, float ty, float tz) {
        TileEntity tileEntity = this.world.func_147438_o(x, y, z);
        if (tileEntity != null & tileEntity instanceof TileEntityCS) {
            TileEntityCS tile = (TileEntityCS)tileEntity;
            tile.BTransX = tx;
            tile.BTransY = ty;
            tile.BTransZ = tz;
        }
    }

    public void setTileEntitySize(ScriptablePosition position, float sx, float sy, float sz) {
        this.setTileEntitySize((int)position.x, (int)position.y, (int)position.y, sx, sy, sz);
    }

    public void setTileEntitySize(int x, int y, int z, float sx, float sy, float sz) {
        TileEntity tileEntity = this.world.func_147438_o(x, y, z);
        if (tileEntity != null & tileEntity instanceof TileEntityCS) {
            TileEntityCS tile = (TileEntityCS)tileEntity;
            tile.BSizeX = sx;
            tile.BSizeY = sy;
            tile.BSizeZ = sz;
        }
    }

    public void setTileEntityRotate(ScriptablePosition position, float r) {
        this.setTileEntityRotate((int)position.x, (int)position.y, (int)position.z, r);
    }

    public void setTileEntityRotate(int x, int y, int z, float r) {
        TileEntity tileEntity = this.world.func_147438_o(x, y, z);
        if (tileEntity != null & tileEntity instanceof TileEntityCS) {
            TileEntityCS tile = (TileEntityCS)tileEntity;
            tile.BRotate = r;
        }
    }
}

