/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common.scripting;

import cubex2.cs3.util.GeneralHelper;
import cubex2.cs3.util.ItemStackHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class ScriptableItemStack {
    public ItemStack stack;

    public ScriptableItemStack(ItemStack stack) {
        this.stack = stack;
    }

    public void setValues(String itemName, int stacksize, int meta) {
        this.stack.func_150996_a(GeneralHelper.getItem(itemName));
        this.stack.field_77994_a = stacksize;
        this.stack.func_77964_b(meta);
    }

    public void setItem(String itemName) {
        this.stack.func_150996_a(GeneralHelper.getItem(itemName));
    }

    public String getItemName() {
        return GeneralHelper.getItemName(this.stack.func_77973_b());
    }

    public void setDamage(int damage) {
        this.stack.func_77964_b(damage);
    }

    public int getDamage() {
        return this.stack.func_77960_j();
    }

    public void setStackSize(int stackSize) {
        this.stack.field_77994_a = stackSize;
    }

    public int getStackSize() {
        return this.stack.field_77994_a;
    }

    public int getMaxStackSize() {
        return this.stack.func_77976_d();
    }

    public void damageItem(int amount) {
        ItemStackHelper.damageItem(this.stack, amount);
    }

    public boolean hasEnchantment() {
        return this.hasEnchantment(-1);
    }

    public boolean hasEnchantment(int id) {
        return this.hasEnchantment(id, -1);
    }

    public boolean hasEnchantment(int id, int level) {
        return ItemStackHelper.hasEnchantment(this.stack, id, level);
    }

    public void clearEnchantments() {
        ItemStackHelper.clearEnchantments(this.stack);
    }

    public void addEnchantment(int id, int level) {
        ItemStackHelper.addEnchantment(this.stack, id, level);
    }

    public void removeEnchantment(int id) {
        ItemStackHelper.removeEnchantment(this.stack, id);
    }

    public int getIntData(String name) {
        return ItemStackHelper.getIntData(this.stack, name);
    }

    public float getFloatData(String name) {
        return ItemStackHelper.getFloatData(this.stack, name);
    }

    public String getStringData(String name) {
        return ItemStackHelper.getStringData(this.stack, name);
    }

    public void setIntData(String name, int data) {
        ItemStackHelper.setIntData(this.stack, name, data);
    }

    public void setFloatData(String name, float data) {
        ItemStackHelper.setFloatData(this.stack, name, data);
    }

    public void setStringData(String name, String data) {
        ItemStackHelper.setStringData(this.stack, name, data);
    }

    public boolean canEfficientlyBreak(String blockName, int metadata) {
        Block block = GeneralHelper.getBlock(blockName);
        return this.stack.func_77973_b().canHarvestBlock(block, this.stack) && this.stack.func_77973_b().getDigSpeed(this.stack, block, metadata) > 1.0f;
    }

    public boolean canHarvest(String blockName) {
        return this.stack.func_77973_b().canHarvestBlock(GeneralHelper.getBlock(blockName), this.stack);
    }
}

