/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common.scripting;

import cubex2.cs3.common.inventory.Inventory;
import cubex2.cs3.common.scripting.ScriptableItemStack;
import cubex2.cs3.util.GeneralHelper;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class ScriptableInventory {
    public Inventory inv;

    public ScriptableInventory(IInventory inventory) {
        this.inv = new Inventory(inventory);
    }

    public ScriptableItemStack getStack(int slot) {
        ItemStack stack = this.inv.getStack(slot);
        if (stack != null) {
            return new ScriptableItemStack(stack);
        }
        return null;
    }

    public void clear() {
        this.inv.clear();
    }

    public int fill(String itemName, int metadata) {
        return this.inv.fill(GeneralHelper.getItem(itemName), metadata);
    }

    public int add(String itemName, int metadata, int count) {
        return this.inv.add(GeneralHelper.getItem(itemName), count, metadata);
    }

    public int remove(String itemName, int metadata, int count) {
        return this.inv.remove(GeneralHelper.getItem(itemName), count, metadata);
    }

    public void clearSlot(int slotId) {
        this.inv.clearSlot(slotId);
    }

    public int fillSlot(int slotId) {
        return this.inv.fillSlot(slotId);
    }

    public int setSlot(int slotId, String itemName, int metadata, int count) {
        return this.inv.setSlot(slotId, GeneralHelper.getItem(itemName), count, metadata);
    }

    public int addToSlot(int slotId, int count) {
        return this.inv.addToSlot(slotId, count);
    }

    public int removeFromSlot(int slotId, int count) {
        return this.inv.removeFromSlot(slotId, count);
    }

    public void damageItem(int slotId, int count) {
        this.inv.damageItem(slotId, count);
    }

    public void repairItem(int slotId) {
        this.inv.repairItem(slotId);
    }

    public void repairItem(int slotId, int count) {
        this.inv.repairItem(slotId, count);
    }

    public String getItemName(int slotId) {
        Item item = this.inv.getItem(slotId);
        return item == null ? null : GeneralHelper.getItemName(item);
    }

    public int getStackSize(int slotId) {
        return this.inv.getStackSize(slotId);
    }

    public int getMaxStackSize(int slotId) {
        return this.inv.getMaxStackSize(slotId);
    }

    public int getDamage(int slotId) {
        return this.inv.getDamage(slotId);
    }

    public int getItemCount(String itemName, int metadata) {
        return this.inv.getItemCount(GeneralHelper.getItem(itemName), metadata);
    }

    public void moveStack(int from, int to) {
        this.inv.moveStack(from, to);
    }

    public boolean isItemEqual(int slot1, int slot2) {
        return this.inv.isItemEqual(slot1, slot2);
    }

    public boolean hasEnchantment(int slotId, int id) {
        return this.inv.hasEnchantment(slotId, id);
    }

    public boolean hasEnchantment(int slotId, int id, int level) {
        return this.inv.hasEnchantment(slotId, id, level);
    }

    public void clearEnchantments(int slotId) {
        this.inv.clearEnchantments(slotId);
    }

    public void addEnchantment(int slotId, int id, int level) {
        this.inv.addEnchantment(slotId, id, level);
    }

    public void removeEnchantment(int slotId, int id) {
        this.inv.removeEnchantment(slotId, id);
    }

    public int getIntData(int slotId, String name) {
        return this.inv.getIntData(slotId, name);
    }

    public float getFloatData(int slotId, String name) {
        return this.inv.getFloatData(slotId, name);
    }

    public String getStringData(int slotId, String name) {
        return this.inv.getStringData(slotId, name);
    }

    public void setIntData(int slotId, String name, int data) {
        this.inv.setIntData(slotId, name, data);
    }

    public void setFloatData(int slotId, String name, float data) {
        this.inv.setFloatData(slotId, name, data);
    }

    public void setStringData(int slotId, String name, String data) {
        this.inv.setStringData(slotId, name, data);
    }

    public boolean canEfficientlyBreak(int slotId, String blockName, int metadata) {
        Block block = GeneralHelper.getBlock(blockName);
        ItemStack stack = this.inv.getStack(slotId);
        return stack != null && stack.func_77973_b().canHarvestBlock(block, stack) && stack.func_77973_b().getDigSpeed(stack, block, metadata) > 1.0f;
    }

    public boolean canHarvest(int slotId, String blockName) {
        Block block = GeneralHelper.getBlock(blockName);
        ItemStack stack = this.inv.getStack(slotId);
        return stack != null && stack.func_77973_b().canHarvestBlock(block, stack);
    }

    public boolean isFuel(int slotId) {
        ItemStack stack = this.inv.getStack(slotId);
        return TileEntityFurnace.func_145954_b((ItemStack)stack);
    }
}

