/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common.scripting;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.WrappedGui;
import cubex2.cs3.common.inventory.Inventory;
import cubex2.cs3.common.inventory.WrappedInventory;
import cubex2.cs3.common.scripting.ScriptableEntityLiving;
import cubex2.cs3.common.scripting.ScriptableInventory;
import cubex2.cs3.common.scripting.ScriptablePosition;
import cubex2.cs3.gui.ContainerBasic;
import cubex2.cs3.gui.EnumGuiType;
import cubex2.cs3.gui.InventoryItemStack;
import cubex2.cs3.gui.WindowNormal;
import cubex2.cs3.handler.event.MessageHandler;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.network.PacketOpenCustomGuiServer;
import cubex2.cs3.network.PacketOpenUserContainerGuiClient;
import cubex2.cs3.registry.GuiRegistry;
import cubex2.cs3.tileentity.TileEntityInventory;
import cubex2.cs3.util.GeneralHelper;
import cubex2.cs3.util.JavaScriptHelper;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.FoodStats;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;

public class ScriptableEntityPlayer
extends ScriptableEntityLiving {
    public EntityPlayer player;
    public Inventory inventory;

    public ScriptableEntityPlayer(EntityPlayer player) {
        super((EntityLivingBase)player);
        this.player = player;
        this.inventory = new Inventory((IInventory)player.field_71071_by);
    }

    public void openGui(String guiName) {
        if (this.player.field_70170_p.field_72995_K) {
            BaseContentPack pack = JavaScriptHelper.executingPack;
            WrappedGui gui = ((GuiRegistry)pack.getContentRegistry(WrappedGui.class)).getGui(guiName);
            this.closeWindows();
            if (gui.getType() == EnumGuiType.NORMAL) {
                this.openClientGui(gui);
            }
        }
    }

    public void openItemGui(String guiName, int slotId) {
        BaseContentPack pack = JavaScriptHelper.executingPack;
        WrappedGui gui = ((GuiRegistry)pack.getContentRegistry(WrappedGui.class)).getGui(guiName);
        if (gui.getType() == EnumGuiType.NORMAL && this.player.field_70170_p.field_72995_K) {
            this.closeWindows();
            if (gui.getType() == EnumGuiType.NORMAL) {
                this.openClientGui(gui);
            }
        } else if (gui.getType() == EnumGuiType.CONTAINER && !this.player.field_70170_p.field_72995_K) {
            PacketOpenCustomGuiServer.openGuiOnServer((EntityPlayerMP)this.player, new PacketOpenUserContainerGuiClient(gui, slotId), new ContainerBasic(gui, this.player, new InventoryItemStack(gui, this.player, slotId)));
        }
    }

    public void openBlockGui(String guiName, ScriptablePosition position) {
        this.openBlockGui(guiName, (int)position.x, (int)position.y, (int)position.z);
    }

    public void openBlockGui(String guiName, int x, int y, int z) {
        BaseContentPack pack = JavaScriptHelper.executingPack;
        WrappedGui gui = ((GuiRegistry)pack.getContentRegistry(WrappedGui.class)).getGui(guiName);
        if (gui.getType() == EnumGuiType.NORMAL && this.player.field_70170_p.field_72995_K) {
            this.closeWindows();
            if (gui.getType() == EnumGuiType.NORMAL) {
                this.openClientGui(gui);
            }
        } else if (gui.getType() == EnumGuiType.CONTAINER && !this.player.field_70170_p.field_72995_K) {
            TileEntity te = this.player.field_70170_p.func_147438_o(x, y, z);
            if (te != null & te instanceof TileEntityInventory) {
                PacketOpenCustomGuiServer.openGuiOnServer((EntityPlayerMP)this.player, new PacketOpenUserContainerGuiClient(gui, x, y, z), new ContainerBasic(gui, this.player, (IInventory)te));
            } else {
                this.player.func_145747_a((IChatComponent)new ChatComponentText("ERROR: Block has no tile entity of type 'inventory'"));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void closeWindows() {
        while (GuiBase.INSTANCE.window instanceof WindowNormal) {
            GuiBase.openPrevWindow();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void openClientGui(WrappedGui gui) {
        FMLClientHandler.instance().showGuiScreen((Object)GuiBase.INSTANCE);
        GuiBase.openWindow(gui.getType().createWindow(gui));
    }

    public void setHunger(int hunger) {
        ReflectionHelper.setPrivateValue(FoodStats.class, (Object)this.player.func_71024_bL(), (Object)hunger, (int)0);
    }

    public int getHunger() {
        return this.player.func_71024_bL().func_75116_a();
    }

    public void setSaturation(double saturation) {
        this.player.func_71024_bL().func_75119_b((float)saturation);
    }

    public double getSaturation() {
        return this.player.func_71024_bL().func_75115_e();
    }

    public void setStepHeight(double f) {
        this.player.field_70138_W = (float)f;
    }

    public double getStepHeight() {
        return this.player.field_70138_W;
    }

    public void sendMessage(String message) {
        if (!this.player.field_70170_p.field_72995_K) {
            this.player.func_146105_b((IChatComponent)new ChatComponentText(message));
        }
    }

    public void sendChat(String chat) {
        if (this.player.field_70170_p.field_72995_K && this.player instanceof EntityClientPlayerMP) {
            if (ClientCommandHandler.instance.func_71556_a((ICommandSender)this.player, chat) != 0) {
                return;
            }
            ((EntityClientPlayerMP)this.player).func_71165_d(chat);
        }
    }

    public String getLatestMessage() {
        return MessageHandler.latestMessage;
    }

    public boolean hasLatestMessage() {
        return !MessageHandler.latestMessage.equals("");
    }

    public void sendCommand(String command) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        ClientCommandHandler.instance.func_71556_a((ICommandSender)server, "/" + command);
    }

    public void setItemInUse() {
        this.player.func_71008_a(this.player.func_71045_bC(), this.player.func_71045_bC().func_77973_b().func_77626_a(this.player.func_71045_bC()));
    }

    public int getCurrentSlot() {
        return this.player.field_71071_by.field_70461_c;
    }

    public boolean placeBlock(ScriptablePosition position, int side, String blockName, int metadata, boolean useFromInventory) {
        return this.placeBlock((int)position.x, (int)position.y, (int)position.z, side, blockName, metadata, useFromInventory);
    }

    public boolean placeBlock(int x, int y, int z, int side, String blockName, int metadata, boolean useFromInventory) {
        ItemStack stack;
        Block block = GeneralHelper.getBlock(blockName);
        World world = this.player.field_70170_p;
        if (useFromInventory) {
            stack = this.inventory.findItem(Item.func_150898_a((Block)block), metadata);
            if (stack == null) {
                return false;
            }
        } else {
            stack = new ItemStack(block, 1, metadata);
        }
        if (block == Blocks.field_150433_aE) {
            side = 1;
        } else if (!(block == Blocks.field_150395_bd || block == Blocks.field_150329_H || block == Blocks.field_150330_I || block != Blocks.field_150350_a && block.isReplaceable((IBlockAccess)world, x, y, z))) {
            switch (side) {
                case 0: {
                    --y;
                    break;
                }
                case 1: {
                    ++y;
                    break;
                }
                case 2: {
                    --z;
                    break;
                }
                case 3: {
                    ++z;
                    break;
                }
                case 4: {
                    --x;
                    break;
                }
                case 5: {
                    ++x;
                }
            }
        }
        if (stack.field_77994_a == 0) {
            return false;
        }
        if (!this.player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        if (y == 255 && block.func_149688_o().func_76220_a()) {
            return false;
        }
        if (world.func_147472_a(block, x, y, z, false, side, (Entity)this.player, stack)) {
            int meta = block.func_149660_a(world, x, y, z, side, 0.0f, 0.0f, 0.0f, stack.func_77960_j());
            if (this.placeBlockAt(block, stack, this.player, world, x, y, z, side, meta)) {
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.field_149762_H.func_150496_b(), (block.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block.field_149762_H.func_150494_d() * 0.8f);
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    private boolean placeBlockAt(Block block, ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, int metadata) {
        if (!world.func_147465_d(x, y, z, block, metadata, 3)) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == block) {
            block.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
            block.func_149714_e(world, x, y, z, metadata);
            world.func_147444_c(x, y, z, block);
        }
        return true;
    }

    private MovingObjectPosition getMop() {
        Vec3 vec1 = Vec3.func_72443_a((double)this.player.field_70165_t, (double)(this.player.field_70163_u + (double)this.player.func_70047_e()), (double)this.player.field_70161_v);
        Vec3 vec2 = this.player.func_70040_Z();
        Vec3 vec3 = vec1.func_72441_c(vec2.field_72450_a * 1000.0, vec2.field_72448_b * 1000.0, vec2.field_72449_c * 1000.0);
        MovingObjectPosition mop = this.player.field_70170_p.func_72933_a(vec1, vec3);
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return mop;
        }
        return null;
    }

    public int getLookX() {
        MovingObjectPosition mop = this.getMop();
        return mop != null ? mop.field_72311_b : -1;
    }

    public int getLookY() {
        MovingObjectPosition mop = this.getMop();
        return mop != null ? mop.field_72312_c : -1;
    }

    public int getLookZ() {
        MovingObjectPosition mop = this.getMop();
        return mop != null ? mop.field_72309_d : -1;
    }

    public void addExperience(int amount) {
        this.player.func_71023_q(amount);
    }

    public void removeExperience(int amount) {
        this.player.field_71067_cb -= amount;
        if (this.player.field_71067_cb < 0) {
            this.player.field_71067_cb = 0;
        }
    }

    public void setExperience(int amount) {
        this.player.field_71067_cb = amount;
        if (this.player.field_71067_cb < 0) {
            this.player.field_71067_cb = 0;
        }
    }

    public void addExperienceLevel(int amount) {
        this.player.func_82242_a(amount);
    }

    public void removeExperienceLevel(int amount) {
        this.player.func_82242_a(-amount);
    }

    public void setExperienceLevel(int level) {
        this.player.field_71068_ca = level;
    }

    public int getExperience() {
        return this.player.field_71067_cb;
    }

    public int getExperienceLevel() {
        return this.player.field_71068_ca;
    }

    public float getHorizontalAngle() {
        return MathHelper.func_76142_g((float)this.player.field_70177_z);
    }

    public float getVerticalAngle() {
        return MathHelper.func_76142_g((float)this.player.field_70125_A);
    }

    public String getUsername() {
        return this.player.func_70005_c_();
    }

    public boolean isSneaking() {
        return this.player.func_70093_af();
    }

    public boolean isSprinting() {
        return this.player.func_70051_ag();
    }

    public void setMaxHealth(int value) {
        value = Math.max(value, 1);
        this.player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)value);
    }

    public void swingItem() {
        this.player.func_71038_i();
    }

    public boolean isInCreative() {
        return this.player.field_71075_bZ.field_75098_d;
    }

    public void damageCurrentItem(int amount) {
        this.getInventory().damageItem(this.getCurrentSlot(), amount);
    }

    public ScriptableInventory getInventory() {
        return new ScriptableInventory((IInventory)this.player.field_71071_by);
    }

    public void openEnderChest(String customName) {
        if (!this.player.field_70170_p.field_72995_K) {
            WrappedInventory inv = new WrappedInventory((IInventory)this.player.func_71005_bN());
            inv.customName = customName;
            this.player.func_71007_a((IInventory)inv);
        }
    }

    public void openEnderChest() {
        this.openEnderChest(null);
    }
}

