/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common.scripting;

import cubex2.cs3.common.scripting.ScriptableEntityItem;
import cubex2.cs3.common.scripting.ScriptableEntityLiving;
import cubex2.cs3.common.scripting.ScriptableEntityPlayer;
import cubex2.cs3.common.scripting.ScriptablePosition;
import cubex2.cs3.util.GeneralHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;

public class ScriptableEntity {
    public Entity entity;

    public ScriptableEntity(Entity entity) {
        this.entity = entity;
    }

    public void setFire(int duration) {
        this.entity.func_70015_d(duration);
    }

    public void extinguish() {
        this.entity.func_70066_B();
    }

    public void setAir(int air) {
        this.entity.func_70050_g(air);
    }

    public void dropItem(String itemName, int damageValue, int stacksize) {
        if (!this.entity.field_70170_p.field_72995_K) {
            this.entity.func_70099_a(new ItemStack(GeneralHelper.getItem(itemName), stacksize, damageValue), 0.0f);
        }
    }

    public void dropItem(ItemStack stack) {
        if (!this.entity.field_70170_p.field_72995_K) {
            this.entity.func_70099_a(stack, 0.0f);
        }
    }

    public double getPosX() {
        return this.entity.field_70165_t;
    }

    public double getPosY() {
        if (this.entity.field_70170_p.field_72995_K) {
            return this.entity.field_70117_cu;
        }
        return this.entity.field_70163_u;
    }

    public double getPosZ() {
        return this.entity.field_70161_v;
    }

    public ScriptablePosition getPosition() {
        return new ScriptablePosition(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
    }

    public void setPosX(double x) {
        this.entity.func_70107_b(x, this.getPosY(), this.getPosZ());
    }

    public void setPosY(double y) {
        this.entity.func_70107_b(this.getPosX(), y, this.getPosZ());
    }

    public void setPosZ(double z) {
        this.entity.func_70107_b(this.getPosX(), this.getPosY(), z);
    }

    public void setPosition(double x, double y, double z) {
        this.entity.func_70107_b(x, y, z);
    }

    public void setPosition(ScriptablePosition position) {
        this.entity.func_70107_b(position.jsGet_x(), position.jsGet_y(), position.jsGet_z());
    }

    public void move(ScriptablePosition pos) {
        this.move(pos.x, pos.y, pos.z);
    }

    public void move(double x, double y, double z) {
        this.entity.func_70091_d(x, y, z);
    }

    public void addVelocityToLookingDirection(double velocity) {
        float yaw = this.entity.field_70177_z;
        float pitch = this.entity.field_70125_A;
        double xHeading = -MathHelper.func_76126_a((float)(yaw * 3.141593f / 180.0f));
        double zHeading = MathHelper.func_76134_b((float)(yaw * 3.141593f / 180.0f));
        double x = velocity * xHeading * (double)MathHelper.func_76134_b((float)(pitch / 180.0f * 3.141593f));
        double y = -velocity * (double)MathHelper.func_76126_a((float)(pitch / 180.0f * 3.141593f));
        double z = velocity * zHeading * (double)MathHelper.func_76134_b((float)(pitch / 180.0f * 3.141593f));
        this.entity.func_70024_g(x, y, z);
    }

    public void setVelocityToLookingDirection(double velocity) {
        float yaw = this.entity.field_70177_z;
        float pitch = this.entity.field_70125_A;
        double xHeading = -MathHelper.func_76126_a((float)(yaw * 3.141593f / 180.0f));
        double zHeading = MathHelper.func_76134_b((float)(yaw * 3.141593f / 180.0f));
        double x = velocity * xHeading * (double)MathHelper.func_76134_b((float)(pitch / 180.0f * 3.141593f));
        double y = -velocity * (double)MathHelper.func_76126_a((float)(pitch / 180.0f * 3.141593f));
        double z = velocity * zHeading * (double)MathHelper.func_76134_b((float)(pitch / 180.0f * 3.141593f));
        this.entity.func_70016_h(x, y, z);
    }

    public void addVelocity(double x, double y, double z) {
        this.entity.func_70024_g(x, y, z);
    }

    public void setVelocity(double x, double y, double z) {
        this.entity.func_70016_h(x, y, z);
    }

    public void setVelocityX(double value) {
        this.entity.field_70159_w = value;
    }

    public void setVelocityY(double value) {
        this.entity.field_70181_x = value;
    }

    public void setVelocityZ(double value) {
        this.entity.field_70179_y = value;
    }

    public double getVelocityX() {
        return this.entity.field_70159_w;
    }

    public double getVelocityY() {
        return this.entity.field_70181_x;
    }

    public double getVelocityZ() {
        return this.entity.field_70179_y;
    }

    public float getFallDistance() {
        return this.entity.field_70143_R;
    }

    public void setFallDistance(float distance) {
        this.entity.field_70143_R = distance;
    }

    public String getName() {
        return EntityList.func_75621_b((Entity)this.entity);
    }

    public void shear() {
        IShearable target;
        if (this.entity instanceof IShearable && (target = (IShearable)this.entity).isShearable(null, (IBlockAccess)this.entity.field_70170_p, (int)this.entity.field_70165_t, (int)this.entity.field_70163_u, (int)this.entity.field_70161_v)) {
            ArrayList drops = target.onSheared(null, (IBlockAccess)this.entity.field_70170_p, (int)this.entity.field_70165_t, (int)this.entity.field_70163_u, (int)this.entity.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, null));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                EntityItem ent = this.entity.func_70099_a(stack, 1.0f);
                ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
            }
        }
    }

    public boolean isLiving() {
        return this.entity instanceof EntityLivingBase;
    }

    public ScriptableEntityLiving asLiving() {
        return new ScriptableEntityLiving((EntityLivingBase)this.entity);
    }

    public boolean isPlayer() {
        return this.entity instanceof EntityPlayer;
    }

    public ScriptableEntityPlayer asPlayer() {
        return new ScriptableEntityPlayer((EntityPlayer)this.entity);
    }

    public boolean isItem() {
        return this.entity instanceof EntityItem;
    }

    public ScriptableEntityItem asItem() {
        return new ScriptableEntityItem((EntityItem)this.entity);
    }

    public void setDead() {
        this.entity.func_70106_y();
    }
}

