/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common.inventory;

import cubex2.cs3.util.ItemStackHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Inventory {
    private IInventory inv;

    public Inventory(IInventory inventory) {
        this.inv = inventory;
    }

    public void clear() {
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            if (this.inv.func_70301_a(i) == null) continue;
            this.inv.func_70299_a(i, null);
        }
    }

    public int fill(Item item, int metadata) {
        int amount = 0;
        int maxStack = item.getItemStackLimit(new ItemStack(item, 1, metadata));
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inv.func_70301_a(i);
            if (itemstack == null) {
                this.inv.func_70299_a(i, new ItemStack(item, maxStack, metadata));
                amount += maxStack;
                continue;
            }
            if (itemstack.func_77973_b() != item || itemstack.func_77960_j() != metadata) continue;
            amount += maxStack - itemstack.field_77994_a;
            this.inv.func_70299_a(i, new ItemStack(item, maxStack, metadata));
        }
        return amount;
    }

    public int add(Item item, int count, int metadata) {
        return this.add(item, count, metadata, this.inv.func_70302_i_() - 1);
    }

    public int add(Item item, int count, int metadata, int maxSlotId) {
        ItemStack stack;
        int amount = 0;
        int slotId = 0;
        while (amount != count && slotId <= this.inv.func_70302_i_() && slotId <= maxSlotId) {
            stack = this.inv.func_70301_a(slotId);
            if (stack == null || stack.func_77973_b() != item || stack.func_77960_j() != metadata || stack.field_77994_a == stack.func_77976_d()) {
                ++slotId;
                continue;
            }
            this.inv.func_70299_a(slotId, new ItemStack(item, stack.field_77994_a + 1, metadata));
            ++amount;
        }
        slotId = 0;
        while (amount != count && slotId <= this.inv.func_70302_i_() && slotId <= maxSlotId) {
            stack = this.inv.func_70301_a(slotId);
            if (stack != null && (stack.func_77973_b() != item || stack.func_77960_j() != metadata || stack.field_77994_a == stack.func_77976_d())) {
                ++slotId;
                continue;
            }
            if (stack == null) {
                this.inv.func_70299_a(slotId, new ItemStack(item, 1, metadata));
                ++amount;
                continue;
            }
            this.inv.func_70299_a(slotId, new ItemStack(item, stack.field_77994_a + 1, metadata));
            ++amount;
        }
        return amount;
    }

    public int remove(Item item, int count, int metadata) {
        int amount = 0;
        int slotId = 0;
        while (amount != count && slotId <= this.inv.func_70302_i_()) {
            ItemStack stack = this.inv.func_70301_a(slotId);
            if (stack == null || stack.func_77973_b() != item || stack.func_77960_j() != metadata) {
                ++slotId;
                continue;
            }
            if (stack.field_77994_a == 1) {
                this.inv.func_70299_a(slotId, null);
                ++amount;
                continue;
            }
            this.inv.func_70299_a(slotId, new ItemStack(item, stack.field_77994_a - 1, metadata));
            ++amount;
        }
        return amount;
    }

    public void clearSlot(int slotId) {
        this.inv.func_70299_a(slotId, null);
    }

    public int fillSlot(int slotId) {
        int amount = 0;
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null) {
            amount = stack.func_77976_d() - stack.field_77994_a;
            this.inv.func_70299_a(slotId, new ItemStack(stack.func_77973_b(), stack.func_77976_d(), stack.func_77960_j()));
        }
        return amount;
    }

    public int setSlot(int slotId, Item item, int count, int metadata) {
        int amount;
        int maxStack = Math.min(count, item.getItemStackLimit(new ItemStack(item, 1, metadata)));
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack == null || stack.func_77973_b() != item || stack.func_77960_j() != metadata) {
            this.inv.func_70299_a(slotId, new ItemStack(item, maxStack, metadata));
            amount = maxStack;
        } else {
            amount = maxStack - stack.field_77994_a;
            this.inv.func_70299_a(slotId, new ItemStack(item, maxStack, metadata));
        }
        return amount;
    }

    public int addToSlot(int slotId, int count) {
        int amount = 0;
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null) {
            amount = Math.min(stack.func_77976_d() - stack.field_77994_a, count);
            this.inv.func_70299_a(slotId, new ItemStack(stack.func_77973_b(), stack.field_77994_a + amount, stack.func_77960_j()));
        }
        return amount;
    }

    public int removeFromSlot(int slotId, int count) {
        int amount = 0;
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null) {
            amount = Math.min(count, stack.field_77994_a);
            if (amount == stack.field_77994_a) {
                this.inv.func_70299_a(slotId, null);
            } else {
                this.inv.func_70299_a(slotId, new ItemStack(stack.func_77973_b(), stack.field_77994_a - amount, stack.func_77960_j()));
            }
        }
        return amount;
    }

    public void damageItem(int slotId, int count) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null && stack.func_77984_f()) {
            stack.func_77964_b(stack.func_77960_j() + count);
            if (stack.func_77960_j() > stack.func_77958_k()) {
                --stack.field_77994_a;
                if (stack.field_77994_a < 0) {
                    stack.field_77994_a = 0;
                }
                stack.func_77964_b(0);
            }
        }
    }

    public void repairItem(int slotId) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null && stack.func_77984_f()) {
            stack.func_77964_b(0);
        }
    }

    public void repairItem(int slotId, int count) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null && stack.func_77984_f()) {
            int amount = Math.min(count, stack.func_77960_j());
            stack.func_77964_b(stack.func_77960_j() - amount);
        }
    }

    public ItemStack getStack(int slotId) {
        return this.inv.func_70301_a(slotId);
    }

    public Item getItem(int slotId) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        return stack == null ? null : stack.func_77973_b();
    }

    public int getStackSize(int slotId) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        return stack == null ? -1 : stack.field_77994_a;
    }

    public int getMaxStackSize(int slotId) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        return stack == null ? -1 : stack.func_77976_d();
    }

    public int getDamage(int slotId) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        return stack == null ? -1 : stack.func_77960_j();
    }

    public int getItemCount(Item item, int metadata) {
        int amount = 0;
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack stack = this.inv.func_70301_a(i);
            if (stack == null || !ItemStackHelper.itemStackEqual(stack, new ItemStack(item, 1, metadata))) continue;
            amount += stack.field_77994_a;
        }
        return amount;
    }

    public void moveStack(int from, int to) {
        if (this.inv.func_70301_a(from) == null) {
            return;
        }
        if (this.inv.func_70301_a(to) == null) {
            ItemStack stack = this.inv.func_70301_a(from);
            this.inv.func_70299_a(from, null);
            this.inv.func_70299_a(to, stack);
        } else if (this.inv.func_70301_a(from).func_77969_a(this.inv.func_70301_a(to))) {
            ItemStack stackFrom = this.inv.func_70301_a(from);
            ItemStack stackTo = this.inv.func_70301_a(to);
            while (stackTo.field_77994_a < stackTo.func_77976_d() && stackFrom.field_77994_a > 0) {
                ++stackTo.field_77994_a;
                --stackFrom.field_77994_a;
            }
            if (stackFrom.field_77994_a == 0) {
                this.inv.func_70299_a(from, null);
            }
        }
    }

    public boolean isItemEqual(int slot1, int slot2) {
        ItemStack stack1 = this.inv.func_70301_a(slot1);
        ItemStack stack2 = this.inv.func_70301_a(slot2);
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 == null ^ stack2 == null) {
            return false;
        }
        return stack1.func_77969_a(stack2);
    }

    public ItemStack findItem(Item item, int metadata) {
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack stack = this.inv.func_70301_a(i);
            if (stack == null || !ItemStackHelper.itemStackEqual(stack, new ItemStack(item, 1, metadata))) continue;
            return stack;
        }
        return null;
    }

    public int findItemIndex(Item item, int metadata) {
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack stack = this.inv.func_70301_a(i);
            if (stack == null || !ItemStackHelper.itemStackEqual(stack, new ItemStack(item, 1, metadata))) continue;
            return i;
        }
        return -1;
    }

    public boolean hasEnchantment(int slotId, int id) {
        return this.hasEnchantment(slotId, id, -1);
    }

    public boolean hasEnchantment(int slotId, int id, int level) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        return stack != null && ItemStackHelper.hasEnchantment(stack, id, level);
    }

    public void clearEnchantments(int slotId) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null) {
            ItemStackHelper.clearEnchantments(stack);
        }
    }

    public void addEnchantment(int slotId, int id, int level) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null) {
            ItemStackHelper.addEnchantment(stack, id, level);
        }
    }

    public void removeEnchantment(int slotId, int id) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null) {
            ItemStackHelper.removeEnchantment(stack, id);
        }
    }

    public int getIntData(int slotId, String name) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null) {
            return ItemStackHelper.getIntData(stack, name);
        }
        return -1;
    }

    public float getFloatData(int slotId, String name) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null) {
            return ItemStackHelper.getFloatData(stack, name);
        }
        return -1.0f;
    }

    public String getStringData(int slotId, String name) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null) {
            return ItemStackHelper.getStringData(stack, name);
        }
        return null;
    }

    public void setIntData(int slotId, String name, int data) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null) {
            ItemStackHelper.setIntData(stack, name, data);
        }
    }

    public void setFloatData(int slotId, String name, float data) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null) {
            ItemStackHelper.setFloatData(stack, name, data);
        }
    }

    public void setStringData(int slotId, String name, String data) {
        ItemStack stack = this.inv.func_70301_a(slotId);
        if (stack != null) {
            ItemStackHelper.setStringData(stack, name, data);
        }
    }
}

