/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common.attribute.bridges;

import cubex2.cs3.common.attribute.AttributeBridge;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class ArrayBridge<T>
extends AttributeBridge<T[]> {
    private final int tagType;

    public ArrayBridge(int tagType) {
        this.tagType = tagType;
    }

    @Override
    public T[] loadValueFromNBT(NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c("Value", this.tagType);
        T[] value = this.createArray(list.func_74745_c());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            value[i] = this.readValueAt(i, list);
        }
        return value;
    }

    @Override
    public void writeValueToNBT(NBTTagCompound compound, T[] value) {
        NBTTagList list = new NBTTagList();
        for (T t : value) {
            list.func_74742_a(this.createTag(t));
        }
        compound.func_74782_a("Value", (NBTBase)list);
    }

    protected abstract NBTBase createTag(T var1);

    protected abstract T[] createArray(int var1);

    protected abstract T readValueAt(int var1, NBTTagList var2);
}

