/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common.attribute;

import com.google.common.collect.Maps;
import cubex2.cs3.common.WrappedTileEntity;
import cubex2.cs3.common.attribute.AttributeBridge;
import cubex2.cs3.common.attribute.NullAttributeBridge;
import cubex2.cs3.common.attribute.bridges.ArmorMaterialBridge;
import cubex2.cs3.common.attribute.bridges.BlockBridge;
import cubex2.cs3.common.attribute.bridges.BlockDropBridge;
import cubex2.cs3.common.attribute.bridges.BooleanBridge;
import cubex2.cs3.common.attribute.bridges.CreativeTabBridge;
import cubex2.cs3.common.attribute.bridges.EnumActionBridge;
import cubex2.cs3.common.attribute.bridges.FloatBridge;
import cubex2.cs3.common.attribute.bridges.FurnaceModulesBridge;
import cubex2.cs3.common.attribute.bridges.GuiDataBridge;
import cubex2.cs3.common.attribute.bridges.IconWrapperBridge;
import cubex2.cs3.common.attribute.bridges.IntegerBridge;
import cubex2.cs3.common.attribute.bridges.ItemStackArrayBridge;
import cubex2.cs3.common.attribute.bridges.ItemStackBridge;
import cubex2.cs3.common.attribute.bridges.MaterialBridge;
import cubex2.cs3.common.attribute.bridges.PotionBridge;
import cubex2.cs3.common.attribute.bridges.ResourceLocationBridge;
import cubex2.cs3.common.attribute.bridges.ScriptWrapperBridge;
import cubex2.cs3.common.attribute.bridges.ShiftClickRulesBridge;
import cubex2.cs3.common.attribute.bridges.StepSoundBridge;
import cubex2.cs3.common.attribute.bridges.StringArrayBridge;
import cubex2.cs3.common.attribute.bridges.StringBridge;
import cubex2.cs3.common.attribute.bridges.ToolClassArrayBridge;
import cubex2.cs3.common.attribute.bridges.WrappedTileEntityBridge;
import cubex2.cs3.gui.data.GuiData;
import cubex2.cs3.gui.data.ShiftClickRules;
import cubex2.cs3.tileentity.data.FurnaceModules;
import cubex2.cs3.util.BlockDrop;
import cubex2.cs3.util.IconWrapper;
import cubex2.cs3.util.ScriptWrapper;
import cubex2.cs3.util.ToolClass;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;

public abstract class DefaultAttributeBridges {
    private static Map<Class<?>, Class<? extends AttributeBridge>> defaultBridges = Maps.newHashMap();

    public static Class<? extends AttributeBridge> getDefaultBridge(Class<?> attributeClass) {
        if (defaultBridges.containsKey(attributeClass)) {
            return defaultBridges.get(attributeClass);
        }
        return NullAttributeBridge.class;
    }

    public static <T> void register(Class<T> attributeClass, Class<? extends AttributeBridge<T>> handlerClass) {
        defaultBridges.put(attributeClass, handlerClass);
    }

    static {
        DefaultAttributeBridges.register(String.class, StringBridge.class);
        DefaultAttributeBridges.register(IconWrapper.class, IconWrapperBridge.class);
        DefaultAttributeBridges.register(Integer.TYPE, IntegerBridge.class);
        DefaultAttributeBridges.register(Boolean.TYPE, BooleanBridge.class);
        DefaultAttributeBridges.register(CreativeTabs.class, CreativeTabBridge.class);
        DefaultAttributeBridges.register(ScriptWrapper.class, ScriptWrapperBridge.class);
        DefaultAttributeBridges.register(EnumAction.class, EnumActionBridge.class);
        DefaultAttributeBridges.register(Float.TYPE, FloatBridge.class);
        DefaultAttributeBridges.register(ItemStack.class, ItemStackBridge.class);
        DefaultAttributeBridges.register(Material.class, MaterialBridge.class);
        DefaultAttributeBridges.register(Block.SoundType.class, StepSoundBridge.class);
        DefaultAttributeBridges.register(BlockDrop.class, BlockDropBridge.class);
        DefaultAttributeBridges.register(String[].class, StringArrayBridge.class);
        DefaultAttributeBridges.register(ToolClass[].class, ToolClassArrayBridge.class);
        DefaultAttributeBridges.register(ItemStack[].class, ItemStackArrayBridge.class);
        DefaultAttributeBridges.register(ItemArmor.ArmorMaterial.class, ArmorMaterialBridge.class);
        DefaultAttributeBridges.register(Block.class, BlockBridge.class);
        DefaultAttributeBridges.register(Potion.class, PotionBridge.class);
        DefaultAttributeBridges.register(WrappedTileEntity.class, WrappedTileEntityBridge.class);
        DefaultAttributeBridges.register(GuiData.class, GuiDataBridge.class);
        DefaultAttributeBridges.register(ShiftClickRules.class, ShiftClickRulesBridge.class);
        DefaultAttributeBridges.register(FurnaceModules.class, FurnaceModulesBridge.class);
        DefaultAttributeBridges.register(ResourceLocation.class, ResourceLocationBridge.class);
    }
}

