/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common.attribute;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.attribute.Attribute;
import cubex2.cs3.common.attribute.AttributeBridge;
import cubex2.cs3.common.attribute.AttributeData;
import cubex2.cs3.common.attribute.DefaultAttributeBridges;
import cubex2.cs3.common.attribute.NullAttributeBridge;
import cubex2.cs3.ingame.gui.Window;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AttributeContainer {
    protected final BaseContentPack pack;
    private final Map<Field, AttributeBridge> bridgeMap = Maps.newHashMap();
    private static final HashMap<Class, Field[]> fieldCache = Maps.newHashMap();
    private static final Predicate<Field> ATTRIBUTE_NO_POST_INIT = new Predicate<Field>(){

        public boolean apply(Field input) {
            return !input.getAnnotation(Attribute.class).loadOnPostInit();
        }
    };
    private static final Predicate<Field> ATTRIBUTE_POST_INIT = new Predicate<Field>(){

        public boolean apply(Field input) {
            return input.getAnnotation(Attribute.class).loadOnPostInit();
        }
    };
    private static final Predicate<Field> ATTRIBUTE_WITH_OWN_WINDOW = new Predicate<Field>(){

        public boolean apply(Field input) {
            return input.getAnnotation(Attribute.class).hasOwnWindow();
        }
    };

    public AttributeContainer(BaseContentPack pack) {
        this.pack = pack;
        this.createBridges();
    }

    public BaseContentPack getPack() {
        return this.pack;
    }

    public void loadFromNBT(NBTTagCompound compound, boolean postInit) {
        Field[] fields = this.getAttributeFields(postInit ? ATTRIBUTE_POST_INIT : ATTRIBUTE_NO_POST_INIT);
        try {
            for (Field field : fields) {
                if (!compound.func_74764_b(field.getName())) continue;
                AttributeBridge bridge = this.bridgeMap.get(field);
                NBTTagCompound attributeCompound = compound.func_74775_l(field.getName());
                field.set(this, bridge.loadValueFromNBT(attributeCompound));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        Field[] fields;
        for (Field field : fields = this.getAttributeFields(new Predicate[0])) {
            try {
                AttributeBridge bridge = this.bridgeMap.get(field);
                NBTTagCompound attributeCompound = new NBTTagCompound();
                Object value = field.get(this);
                bridge.writeValueToNBT(attributeCompound, value);
                compound.func_74782_a(field.getName(), (NBTBase)attributeCompound);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Field[] getFields() {
        Class<?> clazz = this.getClass();
        if (fieldCache.containsKey(clazz)) {
            return fieldCache.get(clazz);
        }
        Field[] classFields = clazz.getFields();
        ArrayList list = Lists.newArrayList();
        for (Field field : classFields) {
            if (!field.isAnnotationPresent(Attribute.class)) continue;
            list.add(field);
        }
        Field[] fields = list.toArray(new Field[list.size()]);
        fieldCache.put(clazz, fields);
        return fields;
    }

    public Field[] getAttributeFields(Predicate<Field> ... predicates) {
        UnmodifiableIterator fields = Iterators.forArray((Object[])this.getFields());
        for (Predicate<Field> pred : predicates) {
            fields = Iterators.filter((Iterator)fields, pred);
        }
        return (Field[])Iterators.toArray((Iterator)fields, Field.class);
    }

    private void createBridges() {
        try {
            for (Field field : this.getAttributeFields(new Predicate[0])) {
                this.bridgeMap.put(field, this.getBridge(field));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private AttributeBridge getBridge(Field field) throws Exception {
        Class<? extends AttributeBridge> bridgeClass = field.getAnnotation(Attribute.class).bridgeClass();
        if (bridgeClass == NullAttributeBridge.class && (bridgeClass = DefaultAttributeBridges.getDefaultBridge(field.getType())) == NullAttributeBridge.class) {
            throw new RuntimeException("Attribute " + field.getName() + " doesn't have a bridge class!");
        }
        AttributeBridge bridge = bridgeClass.newInstance();
        bridge.additionalInfo = field.getAnnotation(Attribute.class).additionalInfo();
        return bridge;
    }

    public AttributeData[] getAttributeDatas(String type) {
        Field[] fields = this.getAttributeFields(ATTRIBUTE_WITH_OWN_WINDOW, new PredicateCheckExclude(type, this));
        AttributeData[] datas = new AttributeData[fields.length];
        for (int i = 0; i < datas.length; ++i) {
            datas[i] = new AttributeData(fields[i].getAnnotation(Attribute.class), fields[i]);
        }
        return datas;
    }

    protected boolean addAttribute(String attribute, String type) {
        return true;
    }

    public <T> T getAttribute(String attributeName) {
        try {
            return (T)this.getClass().getField(attributeName).get(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> void setAttribute(String attributeName, T value) {
        try {
            this.getClass().getField(attributeName).set(this, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Class<? extends Window> getWindowClass(AttributeData item) {
        return item.attribute.windowClass();
    }

    private static class PredicateCheckExclude
    implements Predicate<Field> {
        private final AttributeContainer container;
        private String type;

        public PredicateCheckExclude(String type, AttributeContainer container) {
            this.type = type;
            this.container = container;
        }

        public boolean apply(Field input) {
            return this.container.addAttribute(input.getName(), this.type);
        }
    }
}

