/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common;

import cubex2.cs3.common.AttributeContent;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.attribute.AttributeContainer;
import cubex2.cs3.util.PostponableTask;
import cubex2.cs3.worldgen.EnumWorldGenType;
import cubex2.cs3.worldgen.WorldGenCS;
import cubex2.cs3.worldgen.attributes.WorldGenAttributes;
import net.minecraft.nbt.NBTTagCompound;

public class WrappedWorldGen
extends AttributeContent
implements Comparable<WrappedWorldGen> {
    public WorldGenCS worldGen;
    public WorldGenAttributes container;
    private EnumWorldGenType type;

    public WrappedWorldGen(String name, EnumWorldGenType type, BaseContentPack pack) {
        super(name, pack);
        this.type = type;
    }

    public WrappedWorldGen(BaseContentPack pack) {
        super(pack);
    }

    @Override
    public AttributeContainer getContainer() {
        return this.container;
    }

    @Override
    public String getTypeString() {
        return this.type.name;
    }

    public EnumWorldGenType getType() {
        return this.type;
    }

    @Override
    public boolean readFromNBT(final NBTTagCompound compound) {
        this.name = compound.func_74779_i("Name");
        this.type = EnumWorldGenType.get(compound.func_74779_i("Type"));
        this.container = this.type.createAttributeContainer(this);
        this.container.loadFromNBT(compound.func_74775_l("Attributes"), false);
        this.pack.postponeHandler.addTask(new PostponableTask(){

            @Override
            protected boolean doWork() {
                WrappedWorldGen.this.container.loadFromNBT(compound.func_74775_l("Attributes"), true);
                return true;
            }
        });
        this.worldGen = this.type.createWorldGen(this);
        return true;
    }

    @Override
    public int compareTo(WrappedWorldGen o) {
        return this.name.compareTo(o.name);
    }
}

