/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cubex2.cs3.api.scripting.TriggerType;
import cubex2.cs3.common.AttributeContent;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.attribute.AttributeContainer;
import cubex2.cs3.common.scripting.TriggerData;
import cubex2.cs3.item.EnumItemType;
import cubex2.cs3.item.ItemCS;
import cubex2.cs3.item.attributes.ItemAttributes;
import cubex2.cs3.util.GeneralHelper;
import cubex2.cs3.util.ItemStackHelper;
import cubex2.cs3.util.JavaScriptHelper;
import cubex2.cs3.util.PostponableTask;
import cubex2.cs3.util.ToolClass;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class WrappedItem
extends AttributeContent
implements Comparable<WrappedItem> {
    public Item item;
    public ItemAttributes container;
    private EnumItemType type;

    public WrappedItem(String name, EnumItemType type, BaseContentPack pack) {
        super(name, pack);
        this.type = type;
    }

    public WrappedItem(BaseContentPack pack) {
        super(pack);
    }

    @Override
    public AttributeContainer getContainer() {
        return this.container;
    }

    @Override
    public String getTypeString() {
        return this.type.name;
    }

    public EnumItemType getType() {
        return this.type;
    }

    private void initItem() {
        this.item.func_77655_b(this.name);
        if (this.container.icon != null) {
            this.item.func_111206_d(this.container.icon.iconString);
        }
        for (ToolClass toolClass : this.container.toolClasses) {
            this.item.setHarvestLevel(toolClass.toolClass, toolClass.harvestLevel);
        }
        Map modLangData = (Map)ReflectionHelper.getPrivateValue(LanguageRegistry.class, (Object)LanguageRegistry.instance(), (String[])new String[]{"modLanguageData"});
        Properties p = (Properties)modLangData.get("en_US");
        p.put("item." + this.name + ".name", this.container.displayName);
    }

    @Override
    public void apply() {
        if (this.item != null) {
            this.initItem();
        }
        super.apply();
    }

    @Override
    public void postInit() {
        if (this.item != null && this.item instanceof ItemCS) {
            ((ItemCS)this.item).postInit();
        }
    }

    @Override
    public boolean canEdit() {
        return this.item != null;
    }

    @Override
    public void edit() {
        super.edit();
    }

    @Override
    public void remove() {
        super.remove();
    }

    @Override
    public boolean readFromNBT(final NBTTagCompound compound) {
        this.name = compound.func_74779_i("Name");
        this.type = EnumItemType.get(compound.func_74779_i("Type"));
        this.container = this.type.createAttributeContainer(this);
        this.container.loadFromNBT(compound.func_74775_l("Attributes"), false);
        this.pack.postponeHandler.addTask(new PostponableTask(){

            @Override
            protected boolean doWork() {
                WrappedItem.this.container.loadFromNBT(compound.func_74775_l("Attributes"), true);
                return true;
            }
        });
        this.item = this.type.createItem(this);
        return true;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.container.maxStack;
    }

    public boolean isFull3D() {
        return this.container.full3d;
    }

    public boolean hasEffect(ItemStack stack) {
        return this.container.hasEffect || stack.func_77948_v();
    }

    public CreativeTabs getCreativeTab() {
        return this.container.creativeTab;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        boolean result = false;
        if (this.container.onUse != null && this.container.onUse.script != null) {
            TriggerData data = new TriggerData("onUse", TriggerType.ITEM, world, player, stack).setPosition(x, y, z).setSideAndHit(side, hitX, hitY, hitZ);
            result = JavaScriptHelper.executeTrigger(this.container.onUse.script, data, this.pack, result);
        }
        return result;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (this.container.onRightClick != null && this.container.onRightClick.script != null) {
            TriggerData data = new TriggerData("onRightClick", TriggerType.ITEM, world, player, stack);
            stack = JavaScriptHelper.executeTrigger(this.container.onRightClick.script, data, this.pack, stack);
        }
        return stack;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        boolean result = false;
        if (this.container.onUseFirst != null && this.container.onUseFirst.script != null) {
            TriggerData data = new TriggerData("onUseFirst", TriggerType.ITEM, world, player, stack).setPosition(x, y, z).setSideAndHit(side, hitX, hitY, hitZ);
            result = JavaScriptHelper.executeTrigger(this.container.onUseFirst.script, data, this.pack, result);
        }
        return result;
    }

    public boolean useItemOnEntity(ItemStack stack, EntityPlayer player, EntityLivingBase target) {
        boolean result = false;
        if (target instanceof EntityPlayer && this.container.onUseOnPlayer != null && this.container.onUseOnPlayer.script != null) {
            TriggerData data = new TriggerData("onUseOnPlayer", TriggerType.ITEM, player.field_70170_p, player, stack).setInteractPlayer((EntityPlayer)target);
            result = JavaScriptHelper.executeTrigger(this.container.onUseOnPlayer.script, data, this.pack, result);
        } else if (this.container.onUseOnEntity != null && this.container.onUseOnEntity.script != null) {
            TriggerData data = new TriggerData("onUseOnEntity", TriggerType.ITEM, player.field_70170_p, player, stack).setLiving(target);
            result = JavaScriptHelper.executeTrigger(this.container.onUseOnEntity.script, data, this.pack, result);
        }
        return result;
    }

    public boolean onBlockDestroyed(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase living) {
        boolean result = false;
        if (this.container.onBlockDestroyed != null && this.container.onBlockDestroyed.script != null && living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            TriggerData data = new TriggerData("onBlockDestroyed", TriggerType.ITEM, world, player, stack).setPosition(x, y, z).setBlockName(GeneralHelper.getBlockName(block));
            result = JavaScriptHelper.executeTrigger(this.container.onBlockDestroyed.script, data, this.pack, result);
        }
        return result;
    }

    public boolean hitEntity(ItemStack stack, EntityLivingBase living1, EntityLivingBase living2) {
        boolean result = false;
        if (this.container.onHitEntity != null && this.container.onHitEntity.script != null && living2 instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living2;
            TriggerData data = new TriggerData("onHitEntity", TriggerType.ITEM, player.field_70170_p, player, stack).setLiving(living1);
            result = JavaScriptHelper.executeTrigger(this.container.onHitEntity.script, data, this.pack, result);
        }
        return result;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        boolean result = false;
        if (this.container.onLeftClickLiving != null && this.container.onLeftClickLiving.script != null && entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            TriggerData data = new TriggerData("onLeftClickLiving", TriggerType.ITEM, player.field_70170_p, player, stack).setLiving((EntityLivingBase)living);
            JavaScriptHelper.executeTrigger(this.container.onLeftClickLiving.script, data, this.pack);
        } else if (this.container.onLeftClickPlayer != null && this.container.onLeftClickPlayer.script != null && entity instanceof EntityPlayer) {
            EntityPlayer interactPlayer = (EntityPlayer)entity;
            TriggerData data = new TriggerData("onLeftClickPlayer", TriggerType.ITEM, player.field_70170_p, player, stack).setInteractPlayer(interactPlayer);
            result = JavaScriptHelper.executeTrigger(this.container.onLeftClickPlayer.script, data, this.pack, result);
        }
        return result;
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int slotId, boolean isCurrentItem) {
        if (this.container.onUpdate != null && this.container.onUpdate.script != null && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            TriggerData data = new TriggerData("onUpdate", TriggerType.ITEM, player.field_70170_p, player, stack).setSlotId(slotId).setIsCurrentItem(isCurrentItem);
            JavaScriptHelper.executeTrigger(this.container.onUpdate.script, data, this.pack);
        }
    }

    public void onCreated(ItemStack stack, World world, EntityPlayer player) {
        if (this.container.onCreated != null && this.container.onCreated.script != null) {
            TriggerData data = new TriggerData("onCreated", TriggerType.ITEM, player.field_70170_p, player, stack);
            JavaScriptHelper.executeTrigger(this.container.onCreated.script, data, this.pack);
        }
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int tickCount) {
        if (this.container.onUsing != null && this.container.onUsing.script != null) {
            TriggerData data = new TriggerData("onUsing", TriggerType.ITEM, player.field_70170_p, player, stack).setTickCount(this.getMaxItemUseDuration(stack) - tickCount);
            JavaScriptHelper.executeTrigger(this.container.onUsing.script, data, this.pack);
        }
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int tickCount) {
        if (this.container.onStoppedUsing != null && this.container.onStoppedUsing.script != null) {
            TriggerData data = new TriggerData("onStoppedUsing", TriggerType.ITEM, player.field_70170_p, player, stack).setTickCount(this.getMaxItemUseDuration(stack) - tickCount);
            JavaScriptHelper.executeTrigger(this.container.onStoppedUsing.script, data, this.pack);
        }
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        boolean result = false;
        if (this.container.onDroppedByPlayer != null && this.container.onDroppedByPlayer.script != null) {
            TriggerData data = new TriggerData("onDroppedByPlayer", TriggerType.ITEM, player.field_70170_p, player, stack);
            result = JavaScriptHelper.executeTrigger(this.container.onDroppedByPlayer.script, data, this.pack, result);
        }
        return result;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        boolean result = false;
        if (this.container.onBlockStartBreak != null && this.container.onBlockStartBreak.script != null) {
            TriggerData data = new TriggerData("onBlockStartBreak", TriggerType.ITEM, player.field_70170_p, player, stack).setPosition(x, y, z);
            result = JavaScriptHelper.executeTrigger(this.container.onBlockStartBreak.script, data, this.pack, result);
        }
        return result;
    }

    public ItemStack onEaten(ItemStack stack, World world, EntityPlayer player) {
        if (this.container.onEaten != null && this.container.onEaten.script != null) {
            TriggerData data = new TriggerData("onEaten", TriggerType.ITEM, player.field_70170_p, player, stack);
            stack = JavaScriptHelper.executeTrigger(this.container.onEaten.script, data, this.pack, stack);
        }
        return stack;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (this.container.toolClasses.length == 1 && this.container.toolClasses[0].toolClass.equals("noHarvest")) {
            return 0.0f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            return this.container.efficiency;
        }
        return 1.0f;
    }

    public boolean canHarvestBlock(Block block) {
        return false;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return this.container.maxUsingDuration;
    }

    public int getItemEnchantability() {
        return this.container.enchantability;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        if (this.container.information == null) {
            return;
        }
        String[] split = this.container.information.split("\n");
        Collections.addAll(list, split);
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return this.container.usingAction;
    }

    public boolean isDamageable() {
        return this.container.maxDamage > 0;
    }

    public int getMaxDamage() {
        return this.container.maxDamage;
    }

    public Multimap getAttributeModifiers(Multimap multimap, UUID uuid) {
        if (this.container.damage >= 1) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(uuid, "Weapon modifier", (double)this.container.damage, 0));
        }
        return multimap;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.container.containerItem != null;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return this.container.containerItem != null ? this.container.containerItem.func_77946_l() : null;
    }

    public boolean getIsRepairable(ItemStack stack, ItemStack material) {
        return this.container.anvilMaterial != null && ItemStackHelper.itemStackEqual(this.container.anvilMaterial, material);
    }

    public boolean doesContainerItemLeaveCraftingGrid(ItemStack stack) {
        return !this.container.leaveContainerItem;
    }

    @Override
    public int compareTo(WrappedItem o) {
        return this.name.compareTo(o.name);
    }
}

