/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common;

import com.google.common.base.Predicate;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cubex2.cs3.api.scripting.TriggerType;
import cubex2.cs3.block.EnumBlockType;
import cubex2.cs3.block.attributes.BlockAttributes;
import cubex2.cs3.common.AttributeContent;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.attribute.Attribute;
import cubex2.cs3.common.attribute.AttributeContainer;
import cubex2.cs3.common.scripting.TriggerData;
import cubex2.cs3.util.GeneralHelper;
import cubex2.cs3.util.IconWrapper;
import cubex2.cs3.util.JavaScriptHelper;
import cubex2.cs3.util.PostponableTask;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WrappedBlock
extends AttributeContent
implements Comparable<WrappedBlock> {
    public Block block;
    public Item blockItem;
    public BlockAttributes container;
    private EnumBlockType type;
    private Random random = new Random();

    public WrappedBlock(String name, EnumBlockType type, BaseContentPack pack) {
        super(name, pack);
        this.type = type;
    }

    public WrappedBlock(BaseContentPack pack) {
        super(pack);
    }

    @Override
    public AttributeContainer getContainer() {
        return this.container;
    }

    @Override
    public String getTypeString() {
        return this.type.name;
    }

    public EnumBlockType getType() {
        return this.type;
    }

    private void initBlock() {
        this.block.func_149663_c(this.name);
        this.block.func_149713_g(this.container.opacity);
        this.blockItem.func_77625_d(this.container.maxStack);
        this.block.func_149672_a(this.container.stepSound);
        this.block.field_149765_K = this.container.slipperiness;
        if (this.container.toolClass != null) {
            this.block.setHarvestLevel(this.container.toolClass, this.container.harvestLevel);
        }
        Map modLangData = (Map)ReflectionHelper.getPrivateValue(LanguageRegistry.class, (Object)LanguageRegistry.instance(), (String[])new String[]{"modLanguageData"});
        Properties p = (Properties)modLangData.get("en_US");
        p.put("tile." + this.getName() + ".name", this.container.displayName);
    }

    @Override
    public boolean canEdit() {
        return this.block != null;
    }

    @Override
    public void apply() {
        if (this.block != null) {
            this.initBlock();
        }
        super.apply();
    }

    @Override
    public boolean readFromNBT(final NBTTagCompound compound) {
        this.name = compound.func_74779_i("Name");
        this.type = EnumBlockType.get(compound.func_74779_i("Type"));
        this.container = this.type.createAttributeContainer(this);
        this.container.loadFromNBT(compound.func_74775_l("Attributes"), false);
        this.pack.postponeHandler.addTask(new PostponableTask(){

            @Override
            protected boolean doWork() {
                WrappedBlock.this.container.loadFromNBT(compound.func_74775_l("Attributes"), true);
                return true;
            }
        });
        this.block = this.type.createBlock(this);
        this.blockItem = (Item)GameData.getItemRegistry().func_82594_a(this.pack.id + ":" + this.getName());
        this.container.postCreateBlock(this.block);
        return true;
    }

    public boolean isOpaqueCube() {
        return !this.container.transparent && !this.container.semiTransparent;
    }

    public int getRenderBlockPass() {
        return this.container.semiTransparent ? 1 : 0;
    }

    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        if (!this.container.tileTransparent) {
            Block block = world.func_147439_a(x, y, z);
            return block != this.block && this.shouldSideBeRenderedDefault(world, x, y, z, side);
        }
        return this.shouldSideBeRenderedDefault(world, x, y, z, side);
    }

    public boolean shouldSideBeRenderedDefault(IBlockAccess world, int x, int y, int z, int side) {
        return side == 0 && this.block.func_149665_z() > 0.0 ? true : (side == 1 && this.block.func_149669_A() < 1.0 ? true : (side == 2 && this.block.func_149706_B() > 0.0 ? true : (side == 3 && this.block.func_149693_C() < 1.0 ? true : (side == 4 && this.block.func_149704_x() > 0.0 ? true : (side == 5 && this.block.func_149753_y() < 1.0 ? true : !world.func_147439_a(x, y, z).func_149662_c())))));
    }

    public boolean hasTileEntity(int metadata) {
        return this.container.tileEntity != null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return this.container.tileEntity.createTileEntity();
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (this.container.onUpdate != null && this.container.onUpdate.script != null) {
            TriggerData data = new TriggerData("onUpdate", TriggerType.BLOCK, world, x, y, z);
            JavaScriptHelper.executeTrigger(this.container.onUpdate.script, data, this.pack);
            world.func_147464_a(x, y, z, this.block, this.block.func_149738_a(world));
        }
    }

    public void removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (this.container.onDestroyedByPlayer != null && this.container.onDestroyedByPlayer.script != null) {
            TriggerData data = new TriggerData("onDestroyedByPlayer", TriggerType.BLOCK, world, x, y, z).setPlayer(player);
            JavaScriptHelper.executeTrigger(this.container.onDestroyedByPlayer.script, data, this.pack);
        }
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighborBlock) {
        TriggerData data;
        if (this.container.onNeighborChange != null && this.container.onNeighborChange.script != null) {
            data = new TriggerData("onNeighborChange", TriggerType.BLOCK, world, x, y, z);
            JavaScriptHelper.executeTrigger(this.container.onNeighborChange.script, data, this.pack);
        }
        if (this.container.onRedstoneSignal != null && this.container.onRedstoneSignal.script != null) {
            data = new TriggerData("onRedstoneSignal", TriggerType.BLOCK, world, x, y, z);
            if (world.func_72864_z(x, y, z)) {
                data.setRedstoneSignal(true);
            } else {
                data.setRedstoneSignal(false);
            }
            JavaScriptHelper.executeTrigger(this.container.onRedstoneSignal.script, data, this.pack);
        }
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        TriggerData data;
        if (this.container.onAdded != null && this.container.onAdded.script != null) {
            data = new TriggerData("onAdded", TriggerType.BLOCK, world, x, y, z);
            JavaScriptHelper.executeTrigger(this.container.onAdded.script, data, this.pack);
        }
        if (this.container.onUpdate != null && this.container.onUpdate.script != null) {
            world.func_147464_a(x, y, z, this.block, this.block.func_149738_a(world));
        }
        if (this.container.onRedstoneSignal != null && this.container.onRedstoneSignal.script != null) {
            data = new TriggerData("onRedstoneSignal", TriggerType.BLOCK, world, x, y, z);
            if (world.func_72864_z(x, y, z)) {
                data.setRedstoneSignal(true);
            } else {
                data.setRedstoneSignal(false);
            }
            JavaScriptHelper.executeTrigger(this.container.onRedstoneSignal.script, data, this.pack);
        }
    }

    public void onBlockBreak(World world, int x, int y, int z, Block block, int meta) {
        if (this.container.onBreak != null && this.container.onBreak.script != null) {
            TriggerData data = new TriggerData("onBreak", TriggerType.BLOCK, world, x, y, z);
            JavaScriptHelper.executeTrigger(this.container.onBreak.script, data, this.pack);
        }
        if (this.container.tileEntity != null) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof IInventory) {
                GeneralHelper.dropItems((IInventory)te, world, x, y, z, block);
            }
            world.func_147475_p(x, y, z);
        }
    }

    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player, int facing, float hitX, float hitY, float hitZ) {
        if (this.container.onActivated != null && this.container.onActivated.script != null) {
            TriggerData data = new TriggerData("onActivated", TriggerType.BLOCK, world, x, y, z).setPlayer(player).setSideAndHit(facing, hitX, hitY, hitZ);
            return JavaScriptHelper.executeTrigger(this.container.onActivated.script, data, this.pack, false);
        }
        return false;
    }

    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        if (this.container.onWalking != null && this.container.onWalking.script != null) {
            TriggerData data = new TriggerData("onWalking", TriggerType.BLOCK, world, x, y, z).setEntity(entity);
            JavaScriptHelper.executeTrigger(this.container.onWalking.script, data, this.pack);
        }
    }

    public void onBlockPlaced(World world, int x, int y, int z, int facing, float hitX, float hitY, float hitZ) {
        if (this.container.onPlaced != null && this.container.onPlaced.script != null) {
            TriggerData data = new TriggerData("onPlaced", TriggerType.BLOCK, world, x, y, z);
            JavaScriptHelper.executeTrigger(this.container.onPlaced.script, data, this.pack);
        }
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        if (this.container.onClicked != null && this.container.onClicked.script != null) {
            TriggerData data = new TriggerData("onClicked", TriggerType.BLOCK, world, x, y, z).setPlayer(player);
            JavaScriptHelper.executeTrigger(this.container.onClicked.script, data, this.pack);
        }
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (this.container.onCollided != null && this.container.onCollided.script != null) {
            TriggerData data = new TriggerData("onCollided", TriggerType.BLOCK, world, x, y, z).setEntity(entity);
            JavaScriptHelper.executeTrigger(this.container.onCollided.script, data, this.pack);
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase living) {
        if (living instanceof EntityPlayer && this.container.onPlacedByPlayer != null && this.container.onPlacedByPlayer.script != null) {
            TriggerData data = new TriggerData("onPlacedByPlayer", TriggerType.BLOCK, world, x, y, z).setPlayer((EntityPlayer)living);
            JavaScriptHelper.executeTrigger(this.container.onPlacedByPlayer.script, data, this.pack);
        } else if (this.container.onPlacedBy != null && this.container.onPlacedBy.script != null) {
            TriggerData data = new TriggerData("onPlacedBy", TriggerType.BLOCK, world, x, y, z).setLiving(living);
            JavaScriptHelper.executeTrigger(this.container.onPlacedBy.script, data, this.pack);
        }
    }

    public void onFallenUpon(World world, int x, int y, int z, Entity entity, float fallDistance) {
        if (this.container.onFallenUpon != null && this.container.onFallenUpon.script != null) {
            TriggerData data = new TriggerData("onFallenUpon", TriggerType.BLOCK, world, x, y, z).setEntity(entity);
            JavaScriptHelper.executeTrigger(this.container.onFallenUpon.script, data, this.pack);
        }
    }

    public boolean onBonemeal(World world, int x, int y, int z, EntityPlayer player) {
        if (this.container.onBonemeal != null && this.container.onBonemeal.script != null) {
            TriggerData data = new TriggerData("onBonemeal", TriggerType.BLOCK, world, x, y, z).setPlayer(player);
            JavaScriptHelper.executeTrigger(this.container.onBonemeal.script, data, this.pack);
        }
        return false;
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        if (this.container.onRandomDisplayTick != null && this.container.onRandomDisplayTick.script != null) {
            TriggerData data = new TriggerData("onRandomDisplayTick", TriggerType.BLOCK, world, x, y, z);
            JavaScriptHelper.executeTrigger(this.container.onRandomDisplayTick.script, data, this.pack);
        }
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return this.container.isWood;
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return this.container.isWood;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return this.container.canSilkHarvest;
    }

    public int tickRate(World world) {
        return this.container.tickrate;
    }

    public float getHardness(int meta) {
        return this.container.hardness;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return this.container.resistance / 5.0f;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.container.light;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.container.flammability;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return this.container.fireSpreadSpeed;
    }

    public boolean doesContainerItemLeaveCraftingGrid(ItemStack stack) {
        return !this.container.leaveContainerItem;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return this.container.containerItem.func_77946_l();
    }

    public IIcon getIcon(int side, int meta) {
        return this.container.getTexture((int)side).icon;
    }

    public void registerBlockIcons(IIconRegister iconRegister) {
        Field[] fields = this.container.getAttributeFields(new Predicate<Field>(){

            public boolean apply(Field input) {
                return input.getType() == IconWrapper.class && input.isAnnotationPresent(Attribute.class);
            }
        });
        try {
            for (Field f : fields) {
                ((IconWrapper)f.get(this.container)).setIcon(iconRegister);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public CreativeTabs getCreativeTabToDisplayOn() {
        return this.container.creativeTab;
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, int side) {
        if (side == 0 && !this.container.canPlaceOnCeiling) {
            return false;
        }
        if (side == 1 && !this.container.canPlaceOnFloor) {
            return false;
        }
        return side <= 1 || this.container.canPlaceOnWall;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        if (this.container.information == null) {
            return;
        }
        String[] split = this.container.information.split("\n");
        Collections.addAll(list, split);
    }

    public int getExpDrop(IBlockAccess world, int metadata, int fortune) {
        int min = this.container.expDropMin;
        int max = this.container.expDropMax;
        return this.random.nextInt(max + 1 - min) + min;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return this.container.drop.getDrops(this.container.useFortune ? fortune + this.container.fortuneModifier : 0, this.random);
    }

    public int getMobilityFlag() {
        return this.container.blocksPiston ? 2 : -1;
    }

    public boolean isBurning(IBlockAccess world, int x, int y, int z) {
        return this.container.isBurning;
    }

    public boolean isBeaconBase(IBlockAccess worldObj, int x, int y, int z, int beaconX, int beaconY, int beaconZ) {
        return this.container.isBeaconBase;
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        return this.container.isFireSource;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.container.pick;
    }

    @Override
    public int compareTo(WrappedBlock o) {
        return this.name.compareTo(o.name);
    }

    public boolean onBlockEventReceived(World world, int x, int y, int z, int id, int data) {
        if (this.container.tileEntity != null) {
            TileEntity tileentity = world.func_147438_o(x, y, z);
            return tileentity != null && tileentity.func_145842_c(id, data);
        }
        return false;
    }
}

