/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common;

import cpw.mods.fml.common.registry.GameRegistry;
import cubex2.cs3.common.BaseContent;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.util.ItemStackHelper;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class SmeltingRecipe
extends BaseContent {
    public ItemStack input;
    public ItemStack result;
    public String recipeList = "vanilla";

    public SmeltingRecipe(String recipeList, ItemStack input, ItemStack result, BaseContentPack pack) {
        super(pack);
        this.recipeList = recipeList;
        this.input = input;
        this.result = result;
    }

    public SmeltingRecipe(BaseContentPack pack) {
        super(pack);
    }

    @Override
    public void apply() {
        this.apply_do();
        super.apply();
    }

    private void apply_do() {
        if (this.recipeList.equals("vanilla")) {
            GameRegistry.addSmelting((ItemStack)this.input, (ItemStack)this.result, (float)0.0f);
        }
    }

    @Override
    public void remove() {
        this.remove_do();
        super.remove();
    }

    private void remove_do() {
        if (this.recipeList.equals("vanilla")) {
            Map smeltingList = FurnaceRecipes.func_77602_a().func_77599_b();
            for (Object o : smeltingList.keySet()) {
                ItemStack stack = (ItemStack)o;
                if (stack.func_77973_b() != this.input.func_77973_b() || stack.func_77960_j() != this.input.func_77960_j()) continue;
                smeltingList.remove(o);
                break;
            }
        }
    }

    @Override
    public void edit() {
        this.remove_do();
        this.apply_do();
        super.edit();
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("Input", (NBTBase)ItemStackHelper.writeToNBTNamed(this.input));
        compound.func_74782_a("Result", (NBTBase)ItemStackHelper.writeToNBTNamed(this.result));
        compound.func_74778_a("RecipeList", this.recipeList);
    }

    @Override
    public boolean readFromNBT(NBTTagCompound compound) {
        this.input = ItemStackHelper.readFromNBTNamed(compound.func_74775_l("Input"));
        this.result = ItemStackHelper.readFromNBTNamed(compound.func_74775_l("Result"));
        if (compound.func_74764_b("RecipeList")) {
            this.recipeList = compound.func_74779_i("RecipeList");
        }
        return this.input != null && this.result != null;
    }

    public ItemStack getResult(ItemStack stack, String list) {
        if (!list.equals(this.recipeList) || stack == null || !this.compareItemStacks(stack, this.input)) {
            return null;
        }
        return this.result;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }
}

