/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common;

import cpw.mods.fml.common.registry.GameRegistry;
import cubex2.cs3.common.BaseContent;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.util.ItemStackHelper;
import cubex2.cs3.util.RecipeInput;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedRecipe
extends BaseContent {
    public RecipeInput[] input;
    public int width;
    public int height;
    public ItemStack result;
    private ShapedOreRecipe recipe;
    private boolean postponed = false;

    public ShapedRecipe(BaseContentPack pack) {
        super(pack);
    }

    public ShapedRecipe(int width, int height, RecipeInput[] input, ItemStack result, BaseContentPack pack) {
        super(pack);
        this.width = width;
        this.height = height;
        this.input = input;
        this.result = result;
    }

    @Override
    public void apply() {
        this.recipe = new ShapedOreRecipe(this.result, this.createRecipeObjects());
        GameRegistry.addRecipe((IRecipe)this.recipe);
        super.apply();
    }

    @Override
    public void remove() {
        CraftingManager.func_77594_a().func_77592_b().remove(this.recipe);
        super.remove();
    }

    @Override
    public void edit() {
        CraftingManager.func_77594_a().func_77592_b().remove(this.recipe);
        this.recipe = new ShapedOreRecipe(this.result, this.createRecipeObjects());
        GameRegistry.addRecipe((IRecipe)this.recipe);
        super.edit();
    }

    private Object[] createRecipeObjects() {
        Object[] recipeObjects = new Object[this.height + this.width * this.height * 2];
        String[] shape = this.createShape();
        System.arraycopy(shape, 0, recipeObjects, 0, shape.length);
        int n = 0;
        for (int i = 0; i < this.width * this.height * 2; i += 2) {
            int idx = i + this.height;
            recipeObjects[idx] = Character.valueOf((char)(this.input[n] != null ? (int)n : 65535));
            recipeObjects[idx + 1] = this.input[n] != null ? this.input[n].getInput() : Blocks.field_150350_a;
            ++n;
        }
        return recipeObjects;
    }

    private String[] createShape() {
        String[] shape = new String[this.height];
        int n = 0;
        for (int i = 0; i < shape.length; ++i) {
            String s = "";
            for (int j = 0; j < this.width; ++j) {
                s = s + (char)n++;
            }
            shape[i] = s;
        }
        return shape;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74774_a("Width", (byte)this.width);
        compound.func_74774_a("Height", (byte)this.height);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.input.length; ++i) {
            if (this.input[i] == null) continue;
            NBTTagCompound compound1 = new NBTTagCompound();
            compound1.func_74774_a("Index", (byte)i);
            this.input[i].writeToNBT(compound1);
            tagList.func_74742_a((NBTBase)compound1);
        }
        compound.func_74782_a("Input", (NBTBase)tagList);
        compound.func_74782_a("Result", (NBTBase)ItemStackHelper.writeToNBTNamed(this.result));
    }

    @Override
    public boolean readFromNBT(NBTTagCompound compound) {
        this.width = compound.func_74771_c("Width");
        this.height = compound.func_74771_c("Height");
        NBTTagList tagList = compound.func_150295_c("Input", 10);
        this.input = new RecipeInput[this.width * this.height];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound1 = tagList.func_150305_b(i);
            byte idx = compound1.func_74771_c("Index");
            this.input[idx] = RecipeInput.loadFromNBT(compound1);
            if (this.input[idx] == null || this.input[idx].getInput() != null) continue;
            return false;
        }
        this.result = ItemStackHelper.readFromNBTNamed(compound.func_74775_l("Result"));
        return this.result != null;
    }
}

