/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common;

import cubex2.cs3.common.BaseContent;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.util.ItemStackHelper;
import cubex2.cs3.util.StackLabelItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryEntry
extends BaseContent
implements StackLabelItem {
    public String oreClass;
    public ItemStack stack;

    public OreDictionaryEntry(String oreClass, ItemStack stack, BaseContentPack pack) {
        super(pack);
        this.oreClass = oreClass;
        this.stack = stack;
    }

    public OreDictionaryEntry(BaseContentPack pack) {
        super(pack);
    }

    @Override
    public void apply() {
        OreDictionary.registerOre((String)this.oreClass, (ItemStack)this.stack);
        super.apply();
    }

    @Override
    public boolean canEdit() {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("OreClass", this.oreClass);
        compound.func_74782_a("Stack", (NBTBase)ItemStackHelper.writeToNBTNamed(this.stack));
    }

    @Override
    public boolean readFromNBT(NBTTagCompound compound) {
        this.oreClass = compound.func_74779_i("OreClass");
        this.stack = ItemStackHelper.readFromNBTNamed(compound.func_74775_l("Stack"));
        return this.stack != null;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public String getLabel() {
        return "Ore Class: " + this.oreClass;
    }
}

