/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cubex2.cs3.common.BaseContent;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.lib.CreatureTypes;
import cubex2.cs3.util.IPurposeStringProvider;
import cubex2.cs3.util.StringProviderPurpose;
import cubex2.cs3.util.Util;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;

public class MobSpawn
extends BaseContent
implements IPurposeStringProvider {
    public String mob;
    public int rate;
    public int min;
    public int max;
    public EnumCreatureType type;
    public List<BiomeGenBase> biomes = Lists.newArrayList();
    private Map<BiomeGenBase, BiomeGenBase.SpawnListEntry> entries = Maps.newHashMap();

    public MobSpawn(BaseContentPack pack) {
        super(pack);
    }

    public MobSpawn(String mob, int rate, int min, int max, EnumCreatureType type, List<BiomeGenBase> biomes, BaseContentPack pack) {
        super(pack);
        this.mob = mob;
        this.rate = rate;
        this.min = min;
        this.max = max;
        this.type = type;
        this.biomes = biomes;
    }

    @Override
    public void apply() {
        this.addEntries();
        super.apply();
    }

    private void addEntries() {
        Class entityClazz = (Class)EntityList.field_75625_b.get(this.mob);
        if (EntityLiving.class.isAssignableFrom(entityClazz)) {
            Class clazz = entityClazz;
            for (BiomeGenBase biome : this.biomes) {
                if (biome == null) continue;
                List spawns = biome.func_76747_a(this.type);
                BiomeGenBase.SpawnListEntry entry = new BiomeGenBase.SpawnListEntry(clazz, this.rate, this.min, this.max);
                spawns.add(entry);
                this.entries.put(biome, entry);
            }
        }
    }

    @Override
    public void edit() {
        this.removeEntries();
        this.addEntries();
        super.edit();
    }

    @Override
    public void remove() {
        this.removeEntries();
        super.remove();
    }

    private void removeEntries() {
        for (BiomeGenBase biome : this.entries.keySet()) {
            List spawns = biome.func_76747_a(this.type);
            if (!this.entries.containsKey(biome)) continue;
            spawns.remove(this.entries.get(biome));
        }
        this.entries.clear();
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("Mob", this.mob);
        compound.func_74768_a("Rate", this.rate);
        compound.func_74768_a("Min", this.min);
        compound.func_74768_a("Max", this.max);
        compound.func_74778_a("Type", CreatureTypes.getName(this.type));
        Util.writeListToNBT("Biomes", this.biomes, Util.NBT_BIOME_WRITER, compound);
    }

    @Override
    public boolean readFromNBT(NBTTagCompound compound) {
        this.mob = compound.func_74779_i("Mob");
        this.rate = compound.func_74762_e("Rate");
        this.min = compound.func_74762_e("Min");
        this.max = compound.func_74762_e("Max");
        this.type = CreatureTypes.getType(compound.func_74779_i("Type"));
        this.biomes = Lists.newArrayList();
        Util.readListFromNBT("Biomes", this.biomes, Util.NBT_BIOME_READER, compound);
        return !this.biomes.contains(null);
    }

    @Override
    public String getStringForPurpose(StringProviderPurpose purpose) {
        if (purpose == StringProviderPurpose.LIST_BOX_ITEM_LABEl) {
            return this.mob + " (" + CreatureTypes.getName(this.type) + ")";
        }
        return null;
    }
}

