/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cubex2.cs3.common.BaseContent;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.util.ItemStackHelper;
import cubex2.cs3.util.StackLabelItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class MobDrop
extends BaseContent
implements StackLabelItem {
    public String mob;
    public ItemStack stack;
    public float chance;
    public boolean playerKillOnly;
    private Class<? extends Entity> clazz;

    public MobDrop(BaseContentPack pack) {
        super(pack);
    }

    public MobDrop(String mob, ItemStack stack, float chance, boolean playerKillOnly, BaseContentPack pack) {
        super(pack);
        this.mob = mob;
        this.stack = stack;
        this.chance = chance;
        this.playerKillOnly = playerKillOnly;
    }

    private Class<? extends Entity> getEntityClass() {
        if (this.clazz == null) {
            this.clazz = (Class)EntityList.field_75625_b.get(this.mob);
        }
        return this.clazz;
    }

    @Override
    public void apply() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        super.apply();
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        Entity source = event.source.func_76346_g();
        Class<? extends Entity> eClass = this.getEntityClass();
        if (eClass != null && eClass == event.entity.getClass() && (!this.playerKillOnly || source != null && source instanceof EntityPlayer) && event.entity.field_70170_p.field_73012_v.nextFloat() <= this.chance) {
            event.entity.func_70099_a(this.stack.func_77946_l(), 0.0f);
        }
    }

    @Override
    public void remove() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        super.remove();
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("Mob", this.mob);
        compound.func_74782_a("Stack", (NBTBase)ItemStackHelper.writeToNBTNamed(this.stack));
        compound.func_74776_a("Chance", this.chance);
        compound.func_74757_a("PlayerKillOnly", this.playerKillOnly);
    }

    @Override
    public boolean readFromNBT(NBTTagCompound compound) {
        this.mob = compound.func_74779_i("Mob");
        this.stack = ItemStackHelper.readFromNBTNamed(compound.func_74775_l("Stack"));
        this.chance = compound.func_74760_g("Chance");
        this.playerKillOnly = compound.func_74767_n("PlayerKillOnly");
        return this.stack != null;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public String getLabel() {
        return this.mob;
    }
}

