/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cubex2.cs3.common.BaseContent;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.util.NBTHelper;
import cubex2.cs3.util.StackLabelItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;

public class GrassPlant
extends BaseContent
implements StackLabelItem {
    public ItemStack block;
    public int weight;
    private BiomeGenBase.FlowerEntry entry;

    public GrassPlant(BaseContentPack pack) {
        super(pack);
    }

    public GrassPlant(ItemStack block, int weight, BaseContentPack pack) {
        super(pack);
        this.block = block;
        this.weight = weight;
    }

    @Override
    public void apply() {
        Block block = Block.func_149634_a((Item)this.block.func_77973_b());
        int meta = this.block.func_77960_j();
        this.entry = new BiomeGenBase.FlowerEntry(block, meta, this.weight);
        this.addToBiomes();
        super.apply();
    }

    private void addToBiomes() {
        for (BiomeGenBase bgb : BiomeGenBase.func_150565_n()) {
            if (bgb == null) continue;
            List entries = (List)ReflectionHelper.getPrivateValue(BiomeGenBase.class, (Object)bgb, (String[])new String[]{"flowers"});
            entries.add(this.entry);
        }
    }

    @Override
    public void remove() {
        this.removeFromBiomes();
        super.remove();
    }

    private void removeFromBiomes() {
        for (BiomeGenBase bgb : BiomeGenBase.func_150565_n()) {
            if (bgb == null) continue;
            List entries = (List)ReflectionHelper.getPrivateValue(BiomeGenBase.class, (Object)bgb, (String[])new String[]{"flowers"});
            entries.remove(this.entry);
        }
    }

    @Override
    public void edit() {
        this.removeFromBiomes();
        this.addToBiomes();
        super.edit();
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTHelper.writeToNBT(this.block, "Block", compound);
        compound.func_74768_a("Weight", this.weight);
    }

    @Override
    public boolean readFromNBT(NBTTagCompound compound) {
        this.block = NBTHelper.readStackFromNBT("Block", compound);
        this.weight = compound.func_74762_e("Weight");
        return this.block != null;
    }

    @Override
    public ItemStack getStack() {
        return this.block;
    }

    @Override
    public String getLabel() {
        return "Weight: " + this.weight;
    }
}

