/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cubex2.cs3.common.BaseContent;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.util.ClientHelper;
import cubex2.cs3.util.CreativeTabCS3;
import cubex2.cs3.util.ItemStackHelper;
import cubex2.cs3.util.StackLabelItem;
import java.util.Map;
import java.util.Properties;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CreativeTab
extends BaseContent
implements StackLabelItem {
    public String name;
    public String label;
    public ItemStack icon;
    private CreativeTabCS3 tab;

    public CreativeTab(BaseContentPack pack) {
        super(pack);
    }

    public CreativeTab(String name, String label, ItemStack icon, BaseContentPack pack) {
        super(pack);
        this.name = name;
        this.label = label;
        this.icon = icon;
    }

    @Override
    public void apply() {
        this.tab = new CreativeTabCS3(this.name, this.icon);
        Map modLangData = (Map)ReflectionHelper.getPrivateValue(LanguageRegistry.class, (Object)LanguageRegistry.instance(), (String[])new String[]{"modLanguageData"});
        Properties p = (Properties)modLangData.get("en_US");
        p.put("itemGroup." + this.name, this.label);
        super.apply();
    }

    @Override
    public void edit() {
        this.tab.icon = this.icon;
        Map modLangData = (Map)ReflectionHelper.getPrivateValue(LanguageRegistry.class, (Object)LanguageRegistry.instance(), (String[])new String[]{"modLanguageData"});
        Properties p = (Properties)modLangData.get("en_US");
        if (p.getProperty("itemgroup." + this.name) == null || !p.getProperty("itemgroup." + this.name).equals(this.label)) {
            p.put("itemGroup." + this.name, this.label);
            ClientHelper.refreshResources(FMLClientHandler.instance().getClient());
        }
        super.edit();
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("Name", this.name);
        compound.func_74778_a("Label", this.label);
        compound.func_74782_a("Icon", (NBTBase)ItemStackHelper.writeToNBTNamed(this.icon));
    }

    @Override
    public boolean readFromNBT(NBTTagCompound compound) {
        this.name = compound.func_74779_i("Name");
        this.label = compound.func_74779_i("Label");
        this.icon = ItemStackHelper.readFromNBTNamed(compound.func_74775_l("Icon"));
        return this.icon != null;
    }

    @Override
    public ItemStack getStack() {
        return this.icon;
    }

    @Override
    public String getLabel() {
        return this.name;
    }
}

