/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cubex2.cs3.common.BaseContent;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.util.GeneralHelper;
import cubex2.cs3.util.ItemStackHelper;
import cubex2.cs3.util.StackLabelItem;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class ChestItem
extends BaseContent
implements StackLabelItem {
    public String chest;
    public ItemStack stack;
    public int minCount = 1;
    public int maxCount = 1;
    public int rarity;
    private String curChest;
    private WeightedRandomChestContent content;

    public ChestItem(ItemStack stack, String chest, int minCount, int maxCount, int rarity, BaseContentPack pack) {
        super(pack);
        this.stack = stack;
        this.chest = chest;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.rarity = rarity;
    }

    public ChestItem(BaseContentPack pack) {
        super(pack);
    }

    @Override
    public void apply() {
        this.content = new WeightedRandomChestContent(this.stack, this.minCount, this.maxCount, this.rarity);
        this.curChest = this.chest;
        ChestGenHooks.getInfo((String)this.chest).addItem(this.content);
        super.apply();
    }

    @Override
    public void remove() {
        this.removeItem();
        super.remove();
    }

    @Override
    public void edit() {
        this.content.field_76297_b = this.stack;
        this.content.field_76295_d = this.minCount;
        this.content.field_76296_e = this.maxCount;
        this.content.field_76292_a = this.rarity;
        if (!this.chest.equals(this.curChest)) {
            this.removeItem();
            ChestGenHooks.getInfo((String)this.chest).addItem(this.content);
            this.curChest = this.chest;
        }
        super.edit();
    }

    private void removeItem() {
        ArrayList contents = (ArrayList)ReflectionHelper.getPrivateValue(ChestGenHooks.class, (Object)ChestGenHooks.getInfo((String)this.curChest), (String[])new String[]{"contents"});
        contents.remove(this.content);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("Chest", this.chest);
        compound.func_74782_a("Item", (NBTBase)ItemStackHelper.writeToNBTNamed(this.stack));
        compound.func_74768_a("MinCount", this.minCount);
        compound.func_74768_a("MaxCount", this.maxCount);
        compound.func_74768_a("Rarity", this.rarity);
    }

    @Override
    public boolean readFromNBT(NBTTagCompound compound) {
        this.chest = compound.func_74779_i("Chest");
        this.stack = ItemStackHelper.readFromNBTNamed(compound.func_74775_l("Item"));
        this.minCount = compound.func_74762_e("MinCount");
        this.maxCount = compound.func_74762_e("MaxCount");
        this.rarity = compound.func_74762_e("Rarity");
        return this.stack != null;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public String getLabel() {
        return this.chest + ", Count: " + GeneralHelper.rangeToString(this.minCount, this.maxCount) + ", Rarity: " + this.rarity;
    }
}

