/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cubex2.cs3.api.IContentPack;
import cubex2.cs3.common.ArmorMaterial;
import cubex2.cs3.common.ChestItem;
import cubex2.cs3.common.Content;
import cubex2.cs3.common.CreativeTab;
import cubex2.cs3.common.DungeonMob;
import cubex2.cs3.common.Fuel;
import cubex2.cs3.common.FuelHandler;
import cubex2.cs3.common.GrassPlant;
import cubex2.cs3.common.GrassSeed;
import cubex2.cs3.common.MobDrop;
import cubex2.cs3.common.MobSpawn;
import cubex2.cs3.common.OreDictionaryEntry;
import cubex2.cs3.common.ShapedRecipe;
import cubex2.cs3.common.ShapelessRecipe;
import cubex2.cs3.common.SmeltingRecipe;
import cubex2.cs3.common.SmeltingRecipeHandler;
import cubex2.cs3.common.TradeRecipe;
import cubex2.cs3.common.WrappedBlock;
import cubex2.cs3.common.WrappedEvent;
import cubex2.cs3.common.WrappedGui;
import cubex2.cs3.common.WrappedItem;
import cubex2.cs3.common.WrappedTileEntity;
import cubex2.cs3.common.WrappedWorldGen;
import cubex2.cs3.registry.ArmorMaterialRegistry;
import cubex2.cs3.registry.BlockRegistry;
import cubex2.cs3.registry.ChestItemRegistry;
import cubex2.cs3.registry.ContentRegistry;
import cubex2.cs3.registry.CreativeTabRegistry;
import cubex2.cs3.registry.DungeonMobRegistry;
import cubex2.cs3.registry.EventRegistry;
import cubex2.cs3.registry.FuelRegistry;
import cubex2.cs3.registry.GrassPlantRegistry;
import cubex2.cs3.registry.GrassSeedRegistry;
import cubex2.cs3.registry.GuiRegistry;
import cubex2.cs3.registry.ItemRegistry;
import cubex2.cs3.registry.MobDropRegistry;
import cubex2.cs3.registry.MobSpawnRegistry;
import cubex2.cs3.registry.OreDictEntryRegistry;
import cubex2.cs3.registry.ShapedRecipeRegistry;
import cubex2.cs3.registry.ShapelessRecipeRegistry;
import cubex2.cs3.registry.SmeltingRecipeRegistry;
import cubex2.cs3.registry.TileEntityRegistry;
import cubex2.cs3.registry.TradeRecipeRegistry;
import cubex2.cs3.registry.WorldGenRegistry;
import cubex2.cs3.util.IOHelper;
import cubex2.cs3.util.IPurposeStringProvider;
import cubex2.cs3.util.NBTHelper;
import cubex2.cs3.util.PostponeHandler;
import cubex2.cs3.util.StringProviderPurpose;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BaseContentPack
implements IContentPack,
IPurposeStringProvider,
Comparable<BaseContentPack> {
    public final String name;
    public final String id;
    public final File directory;
    public final PostponeHandler postponeHandler = new PostponeHandler();
    protected final Logger logger;
    protected final List<ContentRegistry> contentRegistryList = Lists.newArrayList();
    protected final Map<Class<? extends Content>, ContentRegistry> contentRegistry = Maps.newHashMap();
    private final Map<String, ContentRegistry> nameToRegistryMap = Maps.newHashMap();
    private boolean initialized = false;
    public final SmeltingRecipeHandler smeltingRecipeHandler = new SmeltingRecipeHandler(this);
    public final FuelHandler fuelHandler = new FuelHandler(this);
    private boolean doSave = true;

    public BaseContentPack(File directory, String name, String id) {
        this.directory = directory;
        this.name = name;
        this.id = id;
        this.logger = Logger.getLogger("CustomStuff3_" + name);
        this.registerContentRegistry(new OreDictEntryRegistry(this), OreDictionaryEntry.class);
        this.registerContentRegistry(new CreativeTabRegistry(this), CreativeTab.class);
        this.registerContentRegistry(new FuelRegistry(this), Fuel.class);
        this.registerContentRegistry(new SmeltingRecipeRegistry(this), SmeltingRecipe.class);
        this.registerContentRegistry(new ShapedRecipeRegistry(this), ShapedRecipe.class);
        this.registerContentRegistry(new ShapelessRecipeRegistry(this), ShapelessRecipe.class);
        this.registerContentRegistry(new ArmorMaterialRegistry(this), ArmorMaterial.class);
        this.registerContentRegistry(new ItemRegistry(this), WrappedItem.class);
        this.registerContentRegistry(new TileEntityRegistry(this), WrappedTileEntity.class);
        this.registerContentRegistry(new GuiRegistry(this), WrappedGui.class);
        this.registerContentRegistry(new BlockRegistry(this), WrappedBlock.class);
        this.registerContentRegistry(new WorldGenRegistry(this), WrappedWorldGen.class);
        this.registerContentRegistry(new TradeRecipeRegistry(this), TradeRecipe.class);
        this.registerContentRegistry(new GrassPlantRegistry(this), GrassPlant.class);
        this.registerContentRegistry(new GrassSeedRegistry(this), GrassSeed.class);
        this.registerContentRegistry(new ChestItemRegistry(this), ChestItem.class);
        this.registerContentRegistry(new MobSpawnRegistry(this), MobSpawn.class);
        this.registerContentRegistry(new DungeonMobRegistry(this), DungeonMob.class);
        this.registerContentRegistry(new MobDropRegistry(this), MobDrop.class);
        this.registerContentRegistry(new EventRegistry(this), WrappedEvent.class);
    }

    public boolean isZipped() {
        return this.directory.isFile();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public List<ContentRegistry> getRegistries() {
        return Collections.unmodifiableList(this.contentRegistryList);
    }

    public <T extends Content> ContentRegistry<T> getContentRegistry(T content) {
        return this.contentRegistry.get(content.getClass());
    }

    public ContentRegistry getContentRegistry(String name) {
        return this.nameToRegistryMap.get(name);
    }

    public <T extends Content> ContentRegistry<T> getContentRegistry(Class<T> clazz) {
        return this.contentRegistry.get(clazz);
    }

    private void registerContentRegistry(ContentRegistry registry, Class<? extends Content> ... classes) {
        for (Class<? extends Content> clazz : classes) {
            this.contentRegistry.put(clazz, registry);
        }
        this.nameToRegistryMap.put(registry.getName(), registry);
        this.contentRegistryList.add(registry);
    }

    public void save() {
        if (!this.initialized || this.isZipped() || !this.doSave) {
            return;
        }
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList managerList = new NBTTagList();
        for (ContentRegistry contentManager : this.contentRegistryList) {
            NBTTagCompound managerTag = new NBTTagCompound();
            contentManager.writeToNBT(managerTag);
            managerList.func_74742_a((NBTBase)managerTag);
        }
        compound.func_74782_a("ManagerList", (NBTBase)managerList);
        IOHelper.writeNBTToFile(compound, new File(this.directory, "data.dat"));
        NBTHelper.dumpNBT(compound, new File(this.directory, "data_dump.txt"));
    }

    public void load() {
        NBTTagCompound compound = IOHelper.readNBTFromPath("data.dat", this);
        if (compound == null) {
            return;
        }
        NBTTagList managerList = compound.func_150295_c("ManagerList", 10);
        for (int i = 0; i < managerList.func_74745_c(); ++i) {
            NBTTagCompound managerTag = managerList.func_150305_b(i);
            String managerName = managerTag.func_74779_i("Name");
            ContentRegistry manager = this.getContentRegistry(managerName);
            manager.readFromNBT(managerTag);
        }
    }

    public void init() {
        this.load();
        this.initialized = true;
    }

    public void postInit() {
        for (ContentRegistry registry : this.contentRegistryList) {
            for (Content content : registry.getContentList()) {
                content.postInit();
            }
        }
        this.doSave = false;
        this.postponeHandler.executePostponedTasks();
        this.doSave = true;
        this.save();
    }

    @Override
    public String getStringForPurpose(StringProviderPurpose purpose) {
        return purpose == StringProviderPurpose.LIST_BOX_ITEM_LABEl ? this.getName() : null;
    }

    @Override
    public int compareTo(BaseContentPack o) {
        return this.name.compareTo(o.name);
    }
}

