/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.block.attributes;

import cubex2.cs3.block.attributes.BlockAttributes;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.attribute.Attribute;
import cubex2.cs3.ingame.gui.block.WindowEditDoorIcon;
import cubex2.cs3.ingame.gui.block.WindowEditTexturesDoor;
import cubex2.cs3.ingame.gui.common.WindowEditBoolean;
import cubex2.cs3.util.BlockDrop;
import cubex2.cs3.util.GeneralHelper;
import cubex2.cs3.util.IconWrapper;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class DoorAttributes
extends BlockAttributes {
    @Attribute(windowClass=WindowEditBoolean.class, additionalInfo="Only redstone can open door")
    public boolean redstoneOnly = false;
    @Attribute(windowClass=WindowEditBoolean.class, additionalInfo="Shade like normal blocks")
    public boolean normalBlockShading = false;
    @Attribute(windowClass=WindowEditDoorIcon.class, customName="icon")
    public IconWrapper iconFile = new IconWrapper("");

    public DoorAttributes(BaseContentPack pack) {
        super(pack);
        this.opacity = 0;
        this.creativeTab = CreativeTabs.field_78028_d;
        this.textureWindow = WindowEditTexturesDoor.class;
    }

    @Override
    public IconWrapper getTexture(String name) {
        if (name.equals("top front")) {
            return this.textureNorth;
        }
        if (name.equals("top sides")) {
            return this.textureSouth;
        }
        if (name.equals("bottom front")) {
            return this.textureEast;
        }
        if (name.equals("bottom sides")) {
            return this.textureWest;
        }
        if (name.equals("doorIcon")) {
            return this.iconFile;
        }
        return super.getTexture(name);
    }

    @Override
    public void postCreateBlock(Block block) {
        Item item;
        if (this.drop == null) {
            item = GeneralHelper.getItem(GeneralHelper.getBlockName(block));
            this.drop = new BlockDrop(item, 0);
        }
        if (this.pick == null) {
            item = GeneralHelper.getItem(GeneralHelper.getBlockName(block));
            this.pick = new ItemStack(item);
        }
    }
}

