/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.block;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.registry.GameRegistry;
import cubex2.cs3.block.BlockCSButton;
import cubex2.cs3.block.BlockCSCarpet;
import cubex2.cs3.block.BlockCSCrossTexture;
import cubex2.cs3.block.BlockCSCrossTexturePost;
import cubex2.cs3.block.BlockCSDoor;
import cubex2.cs3.block.BlockCSFacing;
import cubex2.cs3.block.BlockCSFence;
import cubex2.cs3.block.BlockCSFenceGate;
import cubex2.cs3.block.BlockCSFlat;
import cubex2.cs3.block.BlockCSFluid;
import cubex2.cs3.block.BlockCSGravity;
import cubex2.cs3.block.BlockCSLadder;
import cubex2.cs3.block.BlockCSNormal;
import cubex2.cs3.block.BlockCSPane;
import cubex2.cs3.block.BlockCSPost;
import cubex2.cs3.block.BlockCSPressurePlate;
import cubex2.cs3.block.BlockCSRenderer;
import cubex2.cs3.block.BlockCSStairs;
import cubex2.cs3.block.BlockCSStep;
import cubex2.cs3.block.BlockCSTorch;
import cubex2.cs3.block.BlockCSTrapDoor;
import cubex2.cs3.block.BlockCSWall;
import cubex2.cs3.block.BlockCSWheat;
import cubex2.cs3.block.attributes.BlockAttributes;
import cubex2.cs3.block.attributes.BlockRendererAttributes;
import cubex2.cs3.block.attributes.ButtonAttributes;
import cubex2.cs3.block.attributes.CarpetAttributes;
import cubex2.cs3.block.attributes.CrossTextureAttributes;
import cubex2.cs3.block.attributes.CrossTexturePostAttributes;
import cubex2.cs3.block.attributes.DoorAttributes;
import cubex2.cs3.block.attributes.FacingAttributes;
import cubex2.cs3.block.attributes.FenceAttributes;
import cubex2.cs3.block.attributes.FenceGateAttributes;
import cubex2.cs3.block.attributes.FlatAttributes;
import cubex2.cs3.block.attributes.FluidAttributes;
import cubex2.cs3.block.attributes.GravityAttributes;
import cubex2.cs3.block.attributes.LadderAttributes;
import cubex2.cs3.block.attributes.PaneAttributes;
import cubex2.cs3.block.attributes.PostAttributes;
import cubex2.cs3.block.attributes.PressurePlateAttributes;
import cubex2.cs3.block.attributes.StairAttributes;
import cubex2.cs3.block.attributes.StepAttributes;
import cubex2.cs3.block.attributes.TorchAttributes;
import cubex2.cs3.block.attributes.TrapDoorAttributes;
import cubex2.cs3.block.attributes.WallAttributes;
import cubex2.cs3.block.attributes.WheatAttributes;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.WrappedBlock;
import cubex2.cs3.item.ItemCSBlock;
import cubex2.cs3.item.ItemCSBlockFacing;
import cubex2.cs3.item.ItemCSDoor;
import cubex2.cs3.item.ItemCSFluid;
import cubex2.cs3.item.ItemCSStep;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;

public enum EnumBlockType {
    BUTTON("button", BlockCSButton.class, ButtonAttributes.class),
    CARPET("carpet", BlockCSCarpet.class, CarpetAttributes.class),
    CROSS_TEXTURE("crossTexture", BlockCSCrossTexture.class, CrossTextureAttributes.class),
    CROSS_TEXTURE_POST("crossTexturePost", BlockCSCrossTexturePost.class, CrossTexturePostAttributes.class, ItemCSBlockFacing.class),
    DOOR("door", BlockCSDoor.class, DoorAttributes.class, ItemCSDoor.class),
    FACING("facing", BlockCSFacing.class, FacingAttributes.class, ItemCSBlockFacing.class),
    FENCE("fence", BlockCSFence.class, FenceAttributes.class),
    FENCE_GATE("fenceGate", BlockCSFenceGate.class, FenceGateAttributes.class),
    FLAT("flat", BlockCSFlat.class, FlatAttributes.class),
    FLATRENDERER("BlockRenderer", BlockCSRenderer.class, BlockRendererAttributes.class),
    FLUID("fluid", BlockCSFluid.class, FluidAttributes.class, ItemCSFluid.class),
    GRAVITY("gravity", BlockCSGravity.class, GravityAttributes.class),
    LADDER("ladder", BlockCSLadder.class, LadderAttributes.class),
    NORMAL("normal", BlockCSNormal.class, BlockAttributes.class),
    PANE("pane", BlockCSPane.class, PaneAttributes.class),
    POST("post", BlockCSPost.class, PostAttributes.class, ItemCSBlockFacing.class),
    PRESSURE_PLATE("pressurePlate", BlockCSPressurePlate.class, PressurePlateAttributes.class),
    SLAB("slab", BlockCSStep.class, StepAttributes.class, ItemCSStep.class),
    STAIRS("stairs", BlockCSStairs.class, StairAttributes.class),
    TORCH("torch", BlockCSTorch.class, TorchAttributes.class),
    TRAP_DOOR("trapDoor", BlockCSTrapDoor.class, TrapDoorAttributes.class),
    WALL("wall", BlockCSWall.class, WallAttributes.class),
    WHEAT("wheat", BlockCSWheat.class, WheatAttributes.class);

    public final String name;
    public final Class<? extends Block> blockClass;
    public final Class<? extends BlockAttributes> attributesClass;
    public final Class<? extends Item> itemClass;
    private static final Map<String, EnumBlockType> map;

    private EnumBlockType(String name, Class<? extends Block> blockClass, Class<? extends BlockAttributes> attributeClass) {
        this(name, blockClass, attributeClass, ItemCSBlock.class);
    }

    private EnumBlockType(String name, Class<? extends Block> blockClass, Class<? extends BlockAttributes> attributesClass, Class<? extends Item> itemClass) {
        this.name = name;
        this.blockClass = blockClass;
        this.attributesClass = attributesClass;
        this.itemClass = itemClass;
    }

    public Block createBlock(WrappedBlock wrappedBlock) {
        try {
            Block block = this.blockClass.getConstructor(WrappedBlock.class).newInstance(wrappedBlock);
            if (ItemBlock.class.isAssignableFrom(this.itemClass)) {
                Class<? extends Item> clazz = this.itemClass;
                GameRegistry.registerBlock((Block)block, clazz, (String)wrappedBlock.getName(), (Object[])new Object[]{wrappedBlock});
            } else {
                GameRegistry.registerBlock((Block)block, null, (String)wrappedBlock.getName());
                Item item = this.itemClass.getConstructor(WrappedBlock.class).newInstance(wrappedBlock);
                GameRegistry.registerItem((Item)item, (String)wrappedBlock.getName());
            }
            return block;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BlockAttributes createAttributeContainer(WrappedBlock wrappedBlock) {
        try {
            return this.attributesClass.getConstructor(BaseContentPack.class).newInstance(wrappedBlock.getPack());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static EnumBlockType get(String name) {
        if (map.isEmpty()) {
            for (EnumBlockType e : EnumBlockType.values()) {
                map.put(e.name, e);
            }
        }
        return map.get(name);
    }

    public static String[] getNames() {
        String[] names = new String[EnumBlockType.values().length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = EnumBlockType.values()[i].name;
        }
        return names;
    }

    static {
        map = Maps.newHashMap();
    }
}

